/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cmp;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PBMParameter
extends ASN1Object {
    private ASN1OctetString a;
    private AlgorithmIdentifier b;
    private ASN1Integer c;
    private AlgorithmIdentifier d;

    private PBMParameter(ASN1Sequence aSN1Sequence) {
        this.a = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
        this.c = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2));
        this.d = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(3));
    }

    public static PBMParameter getInstance(Object object) {
        if (object instanceof PBMParameter) {
            return (PBMParameter)object;
        }
        if (object != null) {
            return new PBMParameter(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PBMParameter(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, int n2, AlgorithmIdentifier algorithmIdentifier2) {
        this(new DEROctetString(byArray), algorithmIdentifier, new ASN1Integer(n2), algorithmIdentifier2);
    }

    public PBMParameter(ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, ASN1Integer aSN1Integer, AlgorithmIdentifier algorithmIdentifier2) {
        this.a = aSN1OctetString;
        this.b = algorithmIdentifier;
        this.c = aSN1Integer;
        this.d = algorithmIdentifier2;
    }

    public ASN1OctetString getSalt() {
        return this.a;
    }

    public AlgorithmIdentifier getOwf() {
        return this.b;
    }

    public ASN1Integer getIterationCount() {
        return this.c;
    }

    public AlgorithmIdentifier getMac() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

