/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.BERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERIA5String;
import com.aspose.psd.internal.bouncycastle.asn1.cms.Evidence;
import com.aspose.psd.internal.bouncycastle.asn1.cms.MetaData;

public class TimeStampedData
extends ASN1Object {
    private ASN1Integer a;
    private DERIA5String b;
    private MetaData c;
    private ASN1OctetString d;
    private Evidence e;

    public TimeStampedData(DERIA5String dERIA5String, MetaData metaData, ASN1OctetString aSN1OctetString, Evidence evidence) {
        this.a = new ASN1Integer(1L);
        this.b = dERIA5String;
        this.c = metaData;
        this.d = aSN1OctetString;
        this.e = evidence;
    }

    private TimeStampedData(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        int n2 = 1;
        if (aSN1Sequence.getObjectAt(n2) instanceof DERIA5String) {
            this.b = DERIA5String.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.getObjectAt(n2) instanceof MetaData || aSN1Sequence.getObjectAt(n2) instanceof ASN1Sequence) {
            this.c = MetaData.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        if (aSN1Sequence.getObjectAt(n2) instanceof ASN1OctetString) {
            this.d = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n2++));
        }
        this.e = Evidence.getInstance(aSN1Sequence.getObjectAt(n2));
    }

    public static TimeStampedData getInstance(Object object) {
        if (object == null || object instanceof TimeStampedData) {
            return (TimeStampedData)object;
        }
        return new TimeStampedData(ASN1Sequence.getInstance(object));
    }

    public DERIA5String getDataUri() {
        return this.b;
    }

    public MetaData getMetaData() {
        return this.c;
    }

    public ASN1OctetString getContent() {
        return this.d;
    }

    public Evidence getTemporalEvidence() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        aSN1EncodableVector.add(this.e);
        return new BERSequence(aSN1EncodableVector);
    }
}

