/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.dvcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.aspose.psd.internal.bouncycastle.asn1.dvcs.Data;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralName;

public class DVCSRequest
extends ASN1Object {
    private DVCSRequestInformation a;
    private Data b;
    private GeneralName c;

    public DVCSRequest(DVCSRequestInformation dVCSRequestInformation, Data data) {
        this(dVCSRequestInformation, data, null);
    }

    public DVCSRequest(DVCSRequestInformation dVCSRequestInformation, Data data, GeneralName generalName) {
        this.a = dVCSRequestInformation;
        this.b = data;
        this.c = generalName;
    }

    private DVCSRequest(ASN1Sequence aSN1Sequence) {
        this.a = DVCSRequestInformation.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = Data.getInstance(aSN1Sequence.getObjectAt(1));
        if (aSN1Sequence.size() > 2) {
            this.c = GeneralName.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public static DVCSRequest getInstance(Object object) {
        if (object instanceof DVCSRequest) {
            return (DVCSRequest)object;
        }
        if (object != null) {
            return new DVCSRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static DVCSRequest getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DVCSRequest.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "DVCSRequest {\nrequestInformation: " + this.a + "\ndata: " + this.b + "\n" + (this.c != null ? "transactionIdentifier: " + this.c + "\n" : "") + "}\n";
    }

    public Data getData() {
        return this.b;
    }

    public DVCSRequestInformation getRequestInformation() {
        return this.a;
    }

    public GeneralName getTransactionIdentifier() {
        return this.c;
    }
}

