/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.asn1.x509;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.X509Extensions;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class X509ExtensionsGenerator {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();

    public void reset() {
        this.a = new Hashtable();
        this.b = new Vector();
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, ASN1Encodable aSN1Encodable) {
        try {
            this.addExtension(aSN1ObjectIdentifier, bl2, aSN1Encodable.toASN1Primitive().getEncoded("DER"));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding value: " + iOException);
        }
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl2, byte[] byArray) {
        if (this.a.containsKey(aSN1ObjectIdentifier)) {
            throw new IllegalArgumentException("extension " + aSN1ObjectIdentifier + " already added");
        }
        this.b.addElement(aSN1ObjectIdentifier);
        this.a.put(aSN1ObjectIdentifier, new X509Extension(bl2, (ASN1OctetString)new DEROctetString(byArray)));
    }

    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    public X509Extensions generate() {
        return new X509Extensions(this.b, this.a);
    }
}

