/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROutputStream;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AttCertValidityPeriod;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Attribute;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AttributeCertificate;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AttributeCertificateInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.cert.AttributeCertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.AttributeCertificateIssuer;
import com.aspose.psd.internal.bouncycastle.cert.CertException;
import com.aspose.psd.internal.bouncycastle.cert.CertIOException;
import com.aspose.psd.internal.bouncycastle.cert.a;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.psd.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509AttributeCertificateHolder
implements Encodable,
Serializable {
    private static final long a = 20170722001L;
    private static Attribute[] b = new Attribute[0];
    private transient AttributeCertificate c;
    private transient Extensions d;

    private static AttributeCertificate a(byte[] byArray) throws IOException {
        try {
            return AttributeCertificate.getInstance(com.aspose.psd.internal.bouncycastle.cert.a.a(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public X509AttributeCertificateHolder(byte[] byArray) throws IOException {
        this(X509AttributeCertificateHolder.a(byArray));
    }

    public X509AttributeCertificateHolder(AttributeCertificate attributeCertificate) {
        this.a(attributeCertificate);
    }

    private void a(AttributeCertificate attributeCertificate) {
        this.c = attributeCertificate;
        this.d = attributeCertificate.getAcinfo().getExtensions();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.c.getEncoded();
    }

    public int getVersion() {
        return this.c.getAcinfo().getVersion().getValue().intValue() + 1;
    }

    public BigInteger getSerialNumber() {
        return this.c.getAcinfo().getSerialNumber().getValue();
    }

    public AttributeCertificateHolder getHolder() {
        return new AttributeCertificateHolder((ASN1Sequence)this.c.getAcinfo().getHolder().toASN1Primitive());
    }

    public AttributeCertificateIssuer getIssuer() {
        return new AttributeCertificateIssuer(this.c.getAcinfo().getIssuer());
    }

    public Date getNotBefore() {
        return com.aspose.psd.internal.bouncycastle.cert.a.a(this.c.getAcinfo().getAttrCertValidityPeriod().getNotBeforeTime());
    }

    public Date getNotAfter() {
        return com.aspose.psd.internal.bouncycastle.cert.a.a(this.c.getAcinfo().getAttrCertValidityPeriod().getNotAfterTime());
    }

    public Attribute[] getAttributes() {
        ASN1Sequence aSN1Sequence = this.c.getAcinfo().getAttributes();
        Attribute[] attributeArray = new Attribute[aSN1Sequence.size()];
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            attributeArray[i2] = Attribute.getInstance(aSN1Sequence.getObjectAt(i2));
        }
        return attributeArray;
    }

    public Attribute[] getAttributes(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ASN1Sequence aSN1Sequence = this.c.getAcinfo().getAttributes();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i2 = 0; i2 != aSN1Sequence.size(); ++i2) {
            Attribute attribute = Attribute.getInstance(aSN1Sequence.getObjectAt(i2));
            if (!attribute.getAttrType().equals(aSN1ObjectIdentifier)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.size() == 0) {
            return b;
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public boolean hasExtensions() {
        return this.d != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.d != null) {
            return this.d.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.d;
    }

    public List getExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.c(this.d);
    }

    public Set getCriticalExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.a(this.d);
    }

    public Set getNonCriticalExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.b(this.d);
    }

    public boolean[] getIssuerUniqueID() {
        return com.aspose.psd.internal.bouncycastle.cert.a.a(this.c.getAcinfo().getIssuerUniqueID());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.c.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.c.getSignatureValue().getOctets();
    }

    public AttributeCertificate toASN1Structure() {
        return this.c;
    }

    public boolean isValidOn(Date date) {
        AttCertValidityPeriod attCertValidityPeriod = this.c.getAcinfo().getAttrCertValidityPeriod();
        return !date.before(com.aspose.psd.internal.bouncycastle.cert.a.a(attCertValidityPeriod.getNotBeforeTime())) && !date.after(com.aspose.psd.internal.bouncycastle.cert.a.a(attCertValidityPeriod.getNotAfterTime()));
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws CertException {
        ContentVerifier contentVerifier;
        AttributeCertificateInfo attributeCertificateInfo = this.c.getAcinfo();
        if (!com.aspose.psd.internal.bouncycastle.cert.a.a(attributeCertificateInfo.getSignature(), this.c.getSignatureAlgorithm())) {
            throw new CertException("signature invalid - algorithm identifier mismatch");
        }
        try {
            contentVerifier = contentVerifierProvider.get(attributeCertificateInfo.getSignature());
            OutputStream outputStream = contentVerifier.getOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(outputStream);
            dEROutputStream.writeObject(attributeCertificateInfo);
            outputStream.close();
        }
        catch (Exception exception) {
            throw new CertException("unable to process signature: " + exception.getMessage(), exception);
        }
        return contentVerifier.verify(this.getSignature());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509AttributeCertificateHolder)) {
            return false;
        }
        X509AttributeCertificateHolder x509AttributeCertificateHolder = (X509AttributeCertificateHolder)object;
        return this.c.equals(x509AttributeCertificateHolder.c);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a(AttributeCertificate.getInstance(objectInputStream.readObject()));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

