/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.DEROutputStream;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x509.TBSCertificate;
import com.aspose.psd.internal.bouncycastle.cert.CertException;
import com.aspose.psd.internal.bouncycastle.cert.CertIOException;
import com.aspose.psd.internal.bouncycastle.cert.a;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.psd.internal.bouncycastle.util.Encodable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class X509CertificateHolder
implements Encodable,
Serializable {
    private static final long a = 20170722001L;
    private transient Certificate b;
    private transient Extensions c;

    private static Certificate a(byte[] byArray) throws IOException {
        try {
            return Certificate.getInstance(com.aspose.psd.internal.bouncycastle.cert.a.a(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public X509CertificateHolder(byte[] byArray) throws IOException {
        this(X509CertificateHolder.a(byArray));
    }

    public X509CertificateHolder(Certificate certificate) {
        this.a(certificate);
    }

    private void a(Certificate certificate) {
        this.b = certificate;
        this.c = certificate.getTBSCertificate().getExtensions();
    }

    public int getVersionNumber() {
        return this.b.getVersionNumber();
    }

    public int getVersion() {
        return this.b.getVersionNumber();
    }

    public boolean hasExtensions() {
        return this.c != null;
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        if (this.c != null) {
            return this.c.getExtension(aSN1ObjectIdentifier);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.c;
    }

    public List getExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.c(this.c);
    }

    public Set getCriticalExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.a(this.c);
    }

    public Set getNonCriticalExtensionOIDs() {
        return com.aspose.psd.internal.bouncycastle.cert.a.b(this.c);
    }

    public BigInteger getSerialNumber() {
        return this.b.getSerialNumber().getValue();
    }

    public X500Name getIssuer() {
        return X500Name.getInstance(this.b.getIssuer());
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.b.getSubject());
    }

    public Date getNotBefore() {
        return this.b.getStartDate().getDate();
    }

    public Date getNotAfter() {
        return this.b.getEndDate().getDate();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.b.getSubjectPublicKeyInfo();
    }

    public Certificate toASN1Structure() {
        return this.b;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.b.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.b.getSignature().getOctets();
    }

    public boolean isValidOn(Date date) {
        return !date.before(this.b.getStartDate().getDate()) && !date.after(this.b.getEndDate().getDate());
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws CertException {
        ContentVerifier contentVerifier;
        TBSCertificate tBSCertificate = this.b.getTBSCertificate();
        if (!com.aspose.psd.internal.bouncycastle.cert.a.a(tBSCertificate.getSignature(), this.b.getSignatureAlgorithm())) {
            throw new CertException("signature invalid - algorithm identifier mismatch");
        }
        try {
            contentVerifier = contentVerifierProvider.get(tBSCertificate.getSignature());
            OutputStream outputStream = contentVerifier.getOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(outputStream);
            dEROutputStream.writeObject(tBSCertificate);
            outputStream.close();
        }
        catch (Exception exception) {
            throw new CertException("unable to process signature: " + exception.getMessage(), exception);
        }
        return contentVerifier.verify(this.getSignature());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509CertificateHolder)) {
            return false;
        }
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
        return this.b.equals(x509CertificateHolder.b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.b.getEncoded();
    }

    private void a(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a(Certificate.getInstance(objectInputStream.readObject()));
    }

    private void a(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

