/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.cmp;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PKIBody;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PKIHeader;
import com.aspose.psd.internal.bouncycastle.asn1.cmp.PKIMessage;
import com.aspose.psd.internal.bouncycastle.cert.CertIOException;
import java.io.IOException;

public class GeneralPKIMessage {
    private final PKIMessage a;

    private static PKIMessage a(byte[] byArray) throws IOException {
        try {
            return PKIMessage.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new CertIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public GeneralPKIMessage(byte[] byArray) throws IOException {
        this(GeneralPKIMessage.a(byArray));
    }

    public GeneralPKIMessage(PKIMessage pKIMessage) {
        this.a = pKIMessage;
    }

    public PKIHeader getHeader() {
        return this.a.getHeader();
    }

    public PKIBody getBody() {
        return this.a.getBody();
    }

    public boolean hasProtection() {
        return this.a.getHeader().getProtectionAlg() != null;
    }

    public PKIMessage toASN1Structure() {
        return this.a;
    }
}

