/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cert.crmf;

import com.aspose.psd.internal.bouncycastle.asn1.crmf.EncryptedValue;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cert.crmf.CRMFException;
import com.aspose.psd.internal.bouncycastle.cert.crmf.EncryptedValuePadder;
import com.aspose.psd.internal.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import com.aspose.psd.internal.bouncycastle.operator.InputDecryptor;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import com.aspose.psd.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedValueParser {
    private EncryptedValue a;
    private EncryptedValuePadder b;

    public EncryptedValueParser(EncryptedValue encryptedValue) {
        this.a = encryptedValue;
    }

    public EncryptedValueParser(EncryptedValue encryptedValue, EncryptedValuePadder encryptedValuePadder) {
        this.a = encryptedValue;
        this.b = encryptedValuePadder;
    }

    private byte[] a(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        if (this.a.getIntendedAlg() != null) {
            throw new UnsupportedOperationException();
        }
        if (this.a.getValueHint() != null) {
            throw new UnsupportedOperationException();
        }
        InputDecryptor inputDecryptor = valueDecryptorGenerator.getValueDecryptor(this.a.getKeyAlg(), this.a.getSymmAlg(), this.a.getEncSymmKey().getBytes());
        InputStream inputStream = inputDecryptor.getInputStream(new ByteArrayInputStream(this.a.getEncValue().getBytes()));
        try {
            byte[] byArray = Streams.readAll(inputStream);
            if (this.b != null) {
                return this.b.getUnpaddedData(byArray);
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CRMFException("Cannot parse decrypted data: " + iOException.getMessage(), iOException);
        }
    }

    public X509CertificateHolder readCertificateHolder(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return new X509CertificateHolder(Certificate.getInstance(this.a(valueDecryptorGenerator)));
    }

    public char[] readPassphrase(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return Strings.fromUTF8ByteArray(this.a(valueDecryptorGenerator)).toCharArray();
    }
}

