/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignerIdentifier;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cms.CMSAttributeTableGenerator;
import com.aspose.psd.internal.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import com.aspose.psd.internal.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import com.aspose.psd.internal.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import com.aspose.psd.internal.bouncycastle.cms.SignerInfoGenerator;
import com.aspose.psd.internal.bouncycastle.operator.ContentSigner;
import com.aspose.psd.internal.bouncycastle.operator.DigestCalculatorProvider;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;

public class SignerInfoGeneratorBuilder {
    private DigestCalculatorProvider a;
    private boolean b;
    private CMSAttributeTableGenerator c;
    private CMSAttributeTableGenerator d;
    private CMSSignatureEncryptionAlgorithmFinder e;

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider) {
        this(digestCalculatorProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public SignerInfoGeneratorBuilder(DigestCalculatorProvider digestCalculatorProvider, CMSSignatureEncryptionAlgorithmFinder cMSSignatureEncryptionAlgorithmFinder) {
        this.a = digestCalculatorProvider;
        this.e = cMSSignatureEncryptionAlgorithmFinder;
    }

    public SignerInfoGeneratorBuilder setDirectSignature(boolean bl2) {
        this.b = bl2;
        return this;
    }

    public SignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.c = cMSAttributeTableGenerator;
        return this;
    }

    public SignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator cMSAttributeTableGenerator) {
        this.d = cMSAttributeTableGenerator;
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure()));
        SignerInfoGenerator signerInfoGenerator = this.a(contentSigner, signerIdentifier);
        signerInfoGenerator.setAssociatedCertificate(x509CertificateHolder);
        return signerInfoGenerator;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] byArray) throws OperatorCreationException {
        SignerIdentifier signerIdentifier = new SignerIdentifier(new DEROctetString(byArray));
        return this.a(contentSigner, signerIdentifier);
    }

    private SignerInfoGenerator a(ContentSigner contentSigner, SignerIdentifier signerIdentifier) throws OperatorCreationException {
        if (this.b) {
            return new SignerInfoGenerator(signerIdentifier, contentSigner, this.a, this.e, true);
        }
        if (this.c != null || this.d != null) {
            if (this.c == null) {
                this.c = new DefaultSignedAttributeTableGenerator();
            }
            return new SignerInfoGenerator(signerIdentifier, contentSigner, this.a, this.e, this.c, this.d);
        }
        return new SignerInfoGenerator(signerIdentifier, contentSigner, this.a, this.e);
    }
}

