/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.DERNull;
import com.aspose.psd.internal.bouncycastle.asn1.DERSet;
import com.aspose.psd.internal.bouncycastle.asn1.cms.Attribute;
import com.aspose.psd.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.psd.internal.bouncycastle.asn1.cms.CMSAlgorithmProtection;
import com.aspose.psd.internal.bouncycastle.asn1.cms.CMSAttributes;
import com.aspose.psd.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignerIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.cms.SignerInfo;
import com.aspose.psd.internal.bouncycastle.asn1.cms.Time;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.DigestInfo;
import com.aspose.psd.internal.bouncycastle.cert.X509CertificateHolder;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.CMSProcessable;
import com.aspose.psd.internal.bouncycastle.cms.CMSProcessableByteArray;
import com.aspose.psd.internal.bouncycastle.cms.CMSSignerDigestMismatchException;
import com.aspose.psd.internal.bouncycastle.cms.CMSVerifierCertificateNotValidException;
import com.aspose.psd.internal.bouncycastle.cms.SignerId;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformationStore;
import com.aspose.psd.internal.bouncycastle.cms.SignerInformationVerifier;
import com.aspose.psd.internal.bouncycastle.cms.n;
import com.aspose.psd.internal.bouncycastle.cms.o;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.OperatorCreationException;
import com.aspose.psd.internal.bouncycastle.operator.RawContentVerifier;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class SignerInformation {
    private final SignerId a;
    private final CMSProcessable b;
    private final byte[] c;
    private final ASN1ObjectIdentifier d;
    private final boolean e;
    private AttributeTable f;
    private AttributeTable g;
    private byte[] h;
    protected final SignerInfo info;
    protected final AlgorithmIdentifier digestAlgorithm;
    protected final AlgorithmIdentifier encryptionAlgorithm;
    protected final ASN1Set signedAttributeSet;
    protected final ASN1Set unsignedAttributeSet;

    SignerInformation(SignerInfo signerInfo, ASN1ObjectIdentifier aSN1ObjectIdentifier, CMSProcessable cMSProcessable, byte[] byArray) {
        this.info = signerInfo;
        this.d = aSN1ObjectIdentifier;
        this.e = aSN1ObjectIdentifier == null;
        SignerIdentifier signerIdentifier = signerInfo.getSID();
        if (signerIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(signerIdentifier.getId());
            this.a = new SignerId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(signerIdentifier.getId());
            this.a = new SignerId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm();
        this.signedAttributeSet = signerInfo.getAuthenticatedAttributes();
        this.unsignedAttributeSet = signerInfo.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        this.c = signerInfo.getEncryptedDigest().getOctets();
        this.b = cMSProcessable;
        this.h = byArray;
    }

    protected SignerInformation(SignerInformation signerInformation) {
        this.info = signerInformation.info;
        this.d = signerInformation.d;
        this.e = signerInformation.isCounterSignature();
        this.a = signerInformation.getSID();
        this.digestAlgorithm = this.info.getDigestAlgorithm();
        this.signedAttributeSet = this.info.getAuthenticatedAttributes();
        this.unsignedAttributeSet = this.info.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = this.info.getDigestEncryptionAlgorithm();
        this.c = this.info.getEncryptedDigest().getOctets();
        this.b = signerInformation.b;
        this.h = signerInformation.h;
    }

    public boolean isCounterSignature() {
        return this.e;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.d;
    }

    private byte[] a(ASN1Encodable aSN1Encodable) throws IOException {
        if (aSN1Encodable != null) {
            return aSN1Encodable.toASN1Primitive().getEncoded();
        }
        return null;
    }

    public SignerId getSID() {
        return this.a;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public AlgorithmIdentifier getDigestAlgorithmID() {
        return this.digestAlgorithm;
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getAlgorithm().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.a(this.digestAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting digest parameters " + exception);
        }
    }

    public byte[] getContentDigest() {
        if (this.h == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return Arrays.clone(this.h);
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getAlgorithm().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.a(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributeSet != null && this.f == null) {
            this.f = new AttributeTable(this.signedAttributeSet);
        }
        return this.f;
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributeSet != null && this.g == null) {
            this.g = new AttributeTable(this.unsignedAttributeSet);
        }
        return this.g;
    }

    public byte[] getSignature() {
        return Arrays.clone(this.c);
    }

    public SignerInformationStore getCounterSignatures() {
        AttributeTable attributeTable = this.getUnsignedAttributes();
        if (attributeTable == null) {
            return new SignerInformationStore(new ArrayList<SignerInformation>(0));
        }
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(CMSAttributes.counterSignature);
        for (int i2 = 0; i2 < aSN1EncodableVector.size(); ++i2) {
            Attribute attribute = (Attribute)aSN1EncodableVector.get(i2);
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set.size() < 1) {
                // empty if block
            }
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(enumeration.nextElement());
                arrayList.add(new SignerInformation(signerInfo, null, new CMSProcessableByteArray(this.getSignature()), null));
            }
        }
        return new SignerInformationStore(arrayList);
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributeSet != null) {
            return this.signedAttributeSet.getEncoded("DER");
        }
        return null;
    }

    private boolean a(SignerInformationVerifier signerInformationVerifier) throws CMSException {
        ASN1Object aSN1Object;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ContentVerifier contentVerifier;
        String string = n.a.a(this.getEncryptionAlgOID());
        try {
            contentVerifier = signerInformationVerifier.getContentVerifier(this.encryptionAlgorithm, this.info.getDigestAlgorithm());
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("can't create content verifier: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        try {
            object4 = contentVerifier.getOutputStream();
            if (this.h == null) {
                object3 = signerInformationVerifier.getDigestCalculator(this.getDigestAlgorithmID());
                if (this.b != null) {
                    object2 = object3.getOutputStream();
                    if (this.signedAttributeSet == null) {
                        if (contentVerifier instanceof RawContentVerifier) {
                            this.b.write((OutputStream)object2);
                        } else {
                            object = new TeeOutputStream((OutputStream)object2, (OutputStream)object4);
                            this.b.write((OutputStream)object);
                            ((OutputStream)object).close();
                        }
                    } else {
                        this.b.write((OutputStream)object2);
                        ((OutputStream)object4).write(this.getEncodedSignedAttributes());
                    }
                    ((OutputStream)object2).close();
                } else if (this.signedAttributeSet != null) {
                    ((OutputStream)object4).write(this.getEncodedSignedAttributes());
                } else {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                this.h = object3.getDigest();
            } else if (this.signedAttributeSet == null) {
                if (this.b != null) {
                    this.b.write((OutputStream)object4);
                }
            } else {
                ((OutputStream)object4).write(this.getEncodedSignedAttributes());
            }
            ((OutputStream)object4).close();
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new CMSException("can't create digest calculator: " + operatorCreationException.getMessage(), operatorCreationException);
        }
        object4 = this.a(CMSAttributes.contentType, "content-type");
        if (object4 == null) {
            if (!this.e && this.signedAttributeSet != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (this.e) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(object4 instanceof ASN1ObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            object3 = (ASN1ObjectIdentifier)object4;
            if (!((ASN1Primitive)object3).equals(this.d)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        object4 = this.getSignedAttributes();
        object3 = this.getUnsignedAttributes();
        if (object3 != null && ((AttributeTable)object3).getAll(CMSAttributes.cmsAlgorithmProtect).size() > 0) {
            throw new CMSException("A cmsAlgorithmProtect attribute MUST be a signed attribute");
        }
        if (object4 != null) {
            object2 = ((AttributeTable)object4).getAll(CMSAttributes.cmsAlgorithmProtect);
            if (((ASN1EncodableVector)object2).size() > 1) {
                throw new CMSException("Only one instance of a cmsAlgorithmProtect attribute can be present");
            }
            if (((ASN1EncodableVector)object2).size() > 0) {
                object = Attribute.getInstance(((ASN1EncodableVector)object2).get(0));
                if (((Attribute)object).getAttrValues().size() != 1) {
                    throw new CMSException("A cmsAlgorithmProtect attribute MUST contain exactly one value");
                }
                aSN1Object = CMSAlgorithmProtection.getInstance(((Attribute)object).getAttributeValues()[0]);
                if (!o.a(((CMSAlgorithmProtection)aSN1Object).getDigestAlgorithm(), this.info.getDigestAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for digestAlgorithm");
                }
                if (!o.a(((CMSAlgorithmProtection)aSN1Object).getSignatureAlgorithm(), this.info.getDigestEncryptionAlgorithm())) {
                    throw new CMSException("CMS Algorithm Identifier Protection check failed for signatureAlgorithm");
                }
            }
        }
        if ((object3 = this.a(CMSAttributes.messageDigest, "message-digest")) == null) {
            if (this.signedAttributeSet != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(object3 instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            object2 = (ASN1OctetString)object3;
            if (!Arrays.constantTimeAreEqual(this.h, ((ASN1OctetString)object2).getOctets())) {
                throw new CMSSignerDigestMismatchException("message-digest attribute value does not match calculated value");
            }
        }
        if (object4 != null && ((AttributeTable)object4).getAll(CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        object3 = this.getUnsignedAttributes();
        if (object3 != null) {
            object2 = ((AttributeTable)object3).getAll(CMSAttributes.counterSignature);
            for (int i2 = 0; i2 < ((ASN1EncodableVector)object2).size(); ++i2) {
                aSN1Object = Attribute.getInstance(((ASN1EncodableVector)object2).get(i2));
                if (((Attribute)aSN1Object).getAttrValues().size() >= 1) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            if (this.signedAttributeSet == null && this.h != null && contentVerifier instanceof RawContentVerifier) {
                object3 = (RawContentVerifier)((Object)contentVerifier);
                if (string.equals("RSA")) {
                    object2 = new DigestInfo(new AlgorithmIdentifier(this.digestAlgorithm.getAlgorithm(), DERNull.INSTANCE), this.h);
                    return object3.verify(((ASN1Object)object2).getEncoded("DER"), this.getSignature());
                }
                return object3.verify(this.h, this.getSignature());
            }
            return contentVerifier.verify(this.getSignature());
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
    }

    public boolean verify(SignerInformationVerifier signerInformationVerifier) throws CMSException {
        X509CertificateHolder x509CertificateHolder;
        Time time = this.a();
        if (signerInformationVerifier.hasAssociatedCertificate() && time != null && !(x509CertificateHolder = signerInformationVerifier.getAssociatedCertificate()).isValidOn(time.getDate())) {
            throw new CMSVerifierCertificateNotValidException("verifier not valid at signingTime");
        }
        return this.a(signerInformationVerifier);
    }

    public SignerInfo toASN1Structure() {
        return this.info;
    }

    private ASN1Primitive a(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) throws CMSException {
        AttributeTable attributeTable = this.getUnsignedAttributes();
        if (attributeTable != null && attributeTable.getAll(aSN1ObjectIdentifier).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable attributeTable2 = this.getSignedAttributes();
        if (attributeTable2 == null) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = attributeTable2.getAll(aSN1ObjectIdentifier);
        switch (aSN1EncodableVector.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(0);
                ASN1Set aSN1Set = attribute.getAttrValues();
                if (aSN1Set.size() != 1) {
                    throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                }
                return aSN1Set.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
    }

    private Time a() throws CMSException {
        ASN1Primitive aSN1Primitive = this.a(CMSAttributes.signingTime, "signing-time");
        if (aSN1Primitive == null) {
            return null;
        }
        try {
            return Time.getInstance(aSN1Primitive);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable attributeTable) {
        SignerInfo signerInfo = signerInformation.info;
        DERSet dERSet = null;
        if (attributeTable != null) {
            dERSet = new DERSet(attributeTable.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), dERSet), signerInformation.d, signerInformation.b, null);
    }

    public static SignerInformation addCounterSigners(SignerInformation signerInformation, SignerInformationStore signerInformationStore) {
        SignerInfo signerInfo = signerInformation.info;
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector aSN1EncodableVector = attributeTable != null ? attributeTable.toASN1EncodableVector() : new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Iterator<SignerInformation> iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector2.add(iterator.next().toASN1Structure());
        }
        aSN1EncodableVector.add(new Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2)));
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(aSN1EncodableVector)), signerInformation.d, signerInformation.b, null);
    }
}

