/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.cms.jcajce;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.cms.CMSException;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.b;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.w;
import com.aspose.psd.internal.bouncycastle.cms.jcajce.x;
import com.aspose.psd.internal.bouncycastle.operator.DefaultSecretKeySizeProvider;
import com.aspose.psd.internal.bouncycastle.operator.GenericKey;
import com.aspose.psd.internal.bouncycastle.operator.OutputEncryptor;
import com.aspose.psd.internal.bouncycastle.operator.SecretKeySizeProvider;
import com.aspose.psd.internal.bouncycastle.operator.jcajce.JceGenericKey;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class JceCMSContentEncryptorBuilder {
    private static final SecretKeySizeProvider a = DefaultSecretKeySizeProvider.INSTANCE;
    private final ASN1ObjectIdentifier b;
    private final int c;
    private EnvelopedDataHelper d = new EnvelopedDataHelper(new b());
    private SecureRandom e;
    private AlgorithmParameters f;

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this(aSN1ObjectIdentifier, a.getKeySize(aSN1ObjectIdentifier));
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2) {
        this.b = aSN1ObjectIdentifier;
        int n3 = a.getKeySize(aSN1ObjectIdentifier);
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.des_EDE3_CBC)) {
            if (n2 != 168 && n2 != n3) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.c = 168;
        } else if (aSN1ObjectIdentifier.equals(OIWObjectIdentifiers.desCBC)) {
            if (n2 != 56 && n2 != n3) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.c = 56;
        } else {
            if (n3 > 0 && n3 != n2) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.c = n2;
        }
    }

    public JceCMSContentEncryptorBuilder setProvider(Provider provider) {
        this.d = new EnvelopedDataHelper(new x(provider));
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(String string) {
        this.d = new EnvelopedDataHelper(new w(string));
        return this;
    }

    public JceCMSContentEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.e = secureRandom;
        return this;
    }

    public JceCMSContentEncryptorBuilder setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        this.f = algorithmParameters;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        return new a(this.b, this.c, this.f, this.e);
    }

    private class a
    implements OutputEncryptor {
        private SecretKey b;
        private AlgorithmIdentifier c;
        private Cipher d;

        a(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws CMSException {
            KeyGenerator keyGenerator = JceCMSContentEncryptorBuilder.this.d.createKeyGenerator(aSN1ObjectIdentifier);
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
            if (n2 < 0) {
                keyGenerator.init(secureRandom);
            } else {
                keyGenerator.init(n2, secureRandom);
            }
            this.d = JceCMSContentEncryptorBuilder.this.d.createCipher(aSN1ObjectIdentifier);
            this.b = keyGenerator.generateKey();
            if (algorithmParameters == null) {
                algorithmParameters = JceCMSContentEncryptorBuilder.this.d.generateParameters(aSN1ObjectIdentifier, this.b, secureRandom);
            }
            try {
                this.d.init(1, (Key)this.b, algorithmParameters, secureRandom);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("unable to initialize cipher: " + generalSecurityException.getMessage(), generalSecurityException);
            }
            if (algorithmParameters == null) {
                algorithmParameters = this.d.getParameters();
            }
            this.c = JceCMSContentEncryptorBuilder.this.d.getAlgorithmIdentifier(aSN1ObjectIdentifier, algorithmParameters);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.c;
        }

        @Override
        public OutputStream getOutputStream(OutputStream outputStream) {
            return new CipherOutputStream(outputStream, this.d);
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.c, this.b);
        }
    }
}

