/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.agreement;

import com.aspose.psd.internal.bouncycastle.crypto.BasicAgreement;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters a;

    @Override
    public void init(CipherParameters cipherParameters) {
        this.a = (ECPrivateKeyParameters)cipherParameters;
    }

    @Override
    public int getFieldSize() {
        return (this.a.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        if (!eCPublicKeyParameters.getParameters().equals(this.a.getParameters())) {
            throw new IllegalStateException("ECDH public key has wrong domain parameters");
        }
        ECPoint eCPoint = this.a.getParameters().getCurve().decodePoint(eCPublicKeyParameters.getQ().getEncoded(false));
        if (eCPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDH");
        }
        ECPoint eCPoint2 = eCPoint.multiply(this.a.getD()).normalize();
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint2.getAffineXCoord().toBigInteger();
    }
}

