/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.digests;

import com.aspose.psd.internal.bouncycastle.crypto.digests.EncodableDigest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.GeneralDigest;
import com.aspose.psd.internal.bouncycastle.util.Memoable;
import com.aspose.psd.internal.bouncycastle.util.Pack;

public class SHA224Digest
extends GeneralDigest
implements EncodableDigest {
    private static final int a = 28;
    private int b;
    private int c;
    private int d;
    private int e;
    private int f;
    private int g;
    private int h;
    private int i;
    private int[] j = new int[64];
    private int k;
    static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    public SHA224Digest() {
        this.reset();
    }

    public SHA224Digest(SHA224Digest sHA224Digest) {
        super(sHA224Digest);
        this.a(sHA224Digest);
    }

    private void a(SHA224Digest sHA224Digest) {
        super.copyIn(sHA224Digest);
        this.b = sHA224Digest.b;
        this.c = sHA224Digest.c;
        this.d = sHA224Digest.d;
        this.e = sHA224Digest.e;
        this.f = sHA224Digest.f;
        this.g = sHA224Digest.g;
        this.h = sHA224Digest.h;
        this.i = sHA224Digest.i;
        System.arraycopy(sHA224Digest.j, 0, this.j, 0, sHA224Digest.j.length);
        this.k = sHA224Digest.k;
    }

    public SHA224Digest(byte[] byArray) {
        super(byArray);
        this.b = Pack.bigEndianToInt(byArray, 16);
        this.c = Pack.bigEndianToInt(byArray, 20);
        this.d = Pack.bigEndianToInt(byArray, 24);
        this.e = Pack.bigEndianToInt(byArray, 28);
        this.f = Pack.bigEndianToInt(byArray, 32);
        this.g = Pack.bigEndianToInt(byArray, 36);
        this.h = Pack.bigEndianToInt(byArray, 40);
        this.i = Pack.bigEndianToInt(byArray, 44);
        this.k = Pack.bigEndianToInt(byArray, 48);
        for (int i2 = 0; i2 != this.k; ++i2) {
            this.j[i2] = Pack.bigEndianToInt(byArray, 52 + i2 * 4);
        }
    }

    @Override
    public String getAlgorithmName() {
        return "SHA-224";
    }

    @Override
    public int getDigestSize() {
        return 28;
    }

    @Override
    protected void processWord(byte[] byArray, int n2) {
        int n3 = byArray[n2] << 24;
        n3 |= (byArray[++n2] & 0xFF) << 16;
        n3 |= (byArray[++n2] & 0xFF) << 8;
        this.j[this.k] = n3 |= byArray[++n2] & 0xFF;
        if (++this.k == 16) {
            this.processBlock();
        }
    }

    @Override
    protected void processLength(long l2) {
        if (this.k > 14) {
            this.processBlock();
        }
        this.j[14] = (int)(l2 >>> 32);
        this.j[15] = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        Pack.intToBigEndian(this.b, byArray, n2);
        Pack.intToBigEndian(this.c, byArray, n2 + 4);
        Pack.intToBigEndian(this.d, byArray, n2 + 8);
        Pack.intToBigEndian(this.e, byArray, n2 + 12);
        Pack.intToBigEndian(this.f, byArray, n2 + 16);
        Pack.intToBigEndian(this.g, byArray, n2 + 20);
        Pack.intToBigEndian(this.h, byArray, n2 + 24);
        this.reset();
        return 28;
    }

    @Override
    public void reset() {
        super.reset();
        this.b = -1056596264;
        this.c = 914150663;
        this.d = 812702999;
        this.e = -150054599;
        this.f = -4191439;
        this.g = 1750603025;
        this.h = 1694076839;
        this.i = -1090891868;
        this.k = 0;
        for (int i2 = 0; i2 != this.j.length; ++i2) {
            this.j[i2] = 0;
        }
    }

    @Override
    protected void processBlock() {
        int n2;
        int n3;
        for (n3 = 16; n3 <= 63; ++n3) {
            this.j[n3] = this.d(this.j[n3 - 2]) + this.j[n3 - 7] + this.c(this.j[n3 - 15]) + this.j[n3 - 16];
        }
        n3 = this.b;
        int n4 = this.c;
        int n5 = this.d;
        int n6 = this.e;
        int n7 = this.f;
        int n8 = this.g;
        int n9 = this.h;
        int n10 = this.i;
        int n11 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            n6 += (n10 += this.b(n7) + this.a(n7, n8, n9) + K[n11] + this.j[n11]);
            n10 += this.a(n3) + this.b(n3, n4, n5);
            n5 += (n9 += this.b(n6) + this.a(n6, n7, n8) + K[++n11] + this.j[n11]);
            n9 += this.a(n10) + this.b(n10, n3, n4);
            n4 += (n8 += this.b(n5) + this.a(n5, n6, n7) + K[++n11] + this.j[n11]);
            n8 += this.a(n9) + this.b(n9, n10, n3);
            n3 += (n7 += this.b(n4) + this.a(n4, n5, n6) + K[++n11] + this.j[n11]);
            n7 += this.a(n8) + this.b(n8, n9, n10);
            n10 += (n6 += this.b(n3) + this.a(n3, n4, n5) + K[++n11] + this.j[n11]);
            n6 += this.a(n7) + this.b(n7, n8, n9);
            n9 += (n5 += this.b(n10) + this.a(n10, n3, n4) + K[++n11] + this.j[n11]);
            n5 += this.a(n6) + this.b(n6, n7, n8);
            n8 += (n4 += this.b(n9) + this.a(n9, n10, n3) + K[++n11] + this.j[n11]);
            n4 += this.a(n5) + this.b(n5, n6, n7);
            n7 += (n3 += this.b(n8) + this.a(n8, n9, n10) + K[++n11] + this.j[n11]);
            n3 += this.a(n4) + this.b(n4, n5, n6);
            ++n11;
        }
        this.b += n3;
        this.c += n4;
        this.d += n5;
        this.e += n6;
        this.f += n7;
        this.g += n8;
        this.h += n9;
        this.i += n10;
        this.k = 0;
        for (n2 = 0; n2 < 16; ++n2) {
            this.j[n2] = 0;
        }
    }

    private int a(int n2, int n3, int n4) {
        return n2 & n3 ^ ~n2 & n4;
    }

    private int b(int n2, int n3, int n4) {
        return n2 & n3 ^ n2 & n4 ^ n3 & n4;
    }

    private int a(int n2) {
        return (n2 >>> 2 | n2 << 30) ^ (n2 >>> 13 | n2 << 19) ^ (n2 >>> 22 | n2 << 10);
    }

    private int b(int n2) {
        return (n2 >>> 6 | n2 << 26) ^ (n2 >>> 11 | n2 << 21) ^ (n2 >>> 25 | n2 << 7);
    }

    private int c(int n2) {
        return (n2 >>> 7 | n2 << 25) ^ (n2 >>> 18 | n2 << 14) ^ n2 >>> 3;
    }

    private int d(int n2) {
        return (n2 >>> 17 | n2 << 15) ^ (n2 >>> 19 | n2 << 13) ^ n2 >>> 10;
    }

    @Override
    public Memoable copy() {
        return new SHA224Digest(this);
    }

    @Override
    public void reset(Memoable memoable) {
        SHA224Digest sHA224Digest = (SHA224Digest)memoable;
        this.a(sHA224Digest);
    }

    @Override
    public byte[] getEncodedState() {
        byte[] byArray = new byte[52 + this.k * 4];
        super.populateState(byArray);
        Pack.intToBigEndian(this.b, byArray, 16);
        Pack.intToBigEndian(this.c, byArray, 20);
        Pack.intToBigEndian(this.d, byArray, 24);
        Pack.intToBigEndian(this.e, byArray, 28);
        Pack.intToBigEndian(this.f, byArray, 32);
        Pack.intToBigEndian(this.g, byArray, 36);
        Pack.intToBigEndian(this.h, byArray, 40);
        Pack.intToBigEndian(this.i, byArray, 44);
        Pack.intToBigEndian(this.k, byArray, 48);
        for (int i2 = 0; i2 != this.k; ++i2) {
            Pack.intToBigEndian(this.j[i2], byArray, 52 + i2 * 4);
        }
        return byArray;
    }
}

