/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.engines;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.params.ElGamalKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ElGamalEngine
implements AsymmetricBlockCipher {
    private ElGamalKeyParameters a;
    private SecureRandom b;
    private boolean c;
    private int d;
    private static final BigInteger e = BigInteger.valueOf(0L);
    private static final BigInteger f = BigInteger.valueOf(1L);
    private static final BigInteger g = BigInteger.valueOf(2L);

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        Object object;
        if (cipherParameters instanceof ParametersWithRandom) {
            object = (ParametersWithRandom)cipherParameters;
            this.a = (ElGamalKeyParameters)((ParametersWithRandom)object).getParameters();
            this.b = ((ParametersWithRandom)object).getRandom();
        } else {
            this.a = (ElGamalKeyParameters)cipherParameters;
            this.b = new SecureRandom();
        }
        this.c = bl2;
        object = this.a.getParameters().getP();
        this.d = ((BigInteger)object).bitLength();
        if (bl2) {
            if (!(this.a instanceof ElGamalPublicKeyParameters)) {
                throw new IllegalArgumentException("ElGamalPublicKeyParameters are required for encryption.");
            }
        } else if (!(this.a instanceof ElGamalPrivateKeyParameters)) {
            throw new IllegalArgumentException("ElGamalPrivateKeyParameters are required for decryption.");
        }
    }

    @Override
    public int getInputBlockSize() {
        if (this.c) {
            return (this.d - 1) / 8;
        }
        return 2 * ((this.d + 7) / 8);
    }

    @Override
    public int getOutputBlockSize() {
        if (this.c) {
            return 2 * ((this.d + 7) / 8);
        }
        return (this.d - 1) / 8;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        int n4;
        if (this.a == null) {
            throw new IllegalStateException("ElGamal engine not initialised");
        }
        int n5 = n4 = this.c ? (this.d - 1 + 7) / 8 : this.getInputBlockSize();
        if (n3 > n4) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        BigInteger bigInteger = this.a.getParameters().getP();
        if (this.a instanceof ElGamalPrivateKeyParameters) {
            byte[] byArray3 = new byte[n3 / 2];
            byte[] byArray4 = new byte[n3 / 2];
            System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n2 + byArray3.length, byArray4, 0, byArray4.length);
            BigInteger bigInteger2 = new BigInteger(1, byArray3);
            BigInteger bigInteger3 = new BigInteger(1, byArray4);
            ElGamalPrivateKeyParameters elGamalPrivateKeyParameters = (ElGamalPrivateKeyParameters)this.a;
            BigInteger bigInteger4 = bigInteger2.modPow(bigInteger.subtract(f).subtract(elGamalPrivateKeyParameters.getX()), bigInteger).multiply(bigInteger3).mod(bigInteger);
            return BigIntegers.asUnsignedByteArray(bigInteger4);
        }
        if (n2 != 0 || n3 != byArray.length) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        } else {
            byArray2 = byArray;
        }
        BigInteger bigInteger5 = new BigInteger(1, byArray2);
        if (bigInteger5.compareTo(bigInteger) >= 0) {
            throw new DataLengthException("input too large for ElGamal cipher.\n");
        }
        ElGamalPublicKeyParameters elGamalPublicKeyParameters = (ElGamalPublicKeyParameters)this.a;
        int n6 = bigInteger.bitLength();
        BigInteger bigInteger6 = new BigInteger(n6, this.b);
        while (bigInteger6.equals(e) || bigInteger6.compareTo(bigInteger.subtract(g)) > 0) {
            bigInteger6 = new BigInteger(n6, this.b);
        }
        BigInteger bigInteger7 = this.a.getParameters().getG();
        BigInteger bigInteger8 = bigInteger7.modPow(bigInteger6, bigInteger);
        BigInteger bigInteger9 = bigInteger5.multiply(elGamalPublicKeyParameters.getY().modPow(bigInteger6, bigInteger)).mod(bigInteger);
        byte[] byArray5 = bigInteger8.toByteArray();
        byte[] byArray6 = bigInteger9.toByteArray();
        byte[] byArray7 = new byte[this.getOutputBlockSize()];
        if (byArray5.length > byArray7.length / 2) {
            System.arraycopy(byArray5, 1, byArray7, byArray7.length / 2 - (byArray5.length - 1), byArray5.length - 1);
        } else {
            System.arraycopy(byArray5, 0, byArray7, byArray7.length / 2 - byArray5.length, byArray5.length);
        }
        if (byArray6.length > byArray7.length / 2) {
            System.arraycopy(byArray6, 1, byArray7, byArray7.length - (byArray6.length - 1), byArray6.length - 1);
        } else {
            System.arraycopy(byArray6, 0, byArray7, byArray7.length - byArray6.length, byArray6.length);
        }
        return byArray7;
    }
}

