/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.engines;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.Wrapper;
import com.aspose.psd.internal.bouncycastle.crypto.engines.RFC3394WrapEngine;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Pack;

public class RFC5649WrapEngine
implements Wrapper {
    private BlockCipher a;
    private KeyParameter b;
    private boolean c;
    private byte[] d = new byte[]{-90, 89, 89, -90};
    private byte[] e = this.d;
    private byte[] f = null;

    public RFC5649WrapEngine(BlockCipher blockCipher) {
        this.a = blockCipher;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.c = bl2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            this.b = (KeyParameter)cipherParameters;
            this.e = this.d;
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.e = ((ParametersWithIV)cipherParameters).getIV();
            this.b = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (this.e.length != 4) {
                throw new IllegalArgumentException("IV length not equal to 4");
            }
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getAlgorithmName();
    }

    private byte[] a(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = (8 - n2 % 8) % 8;
        byte[] byArray2 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n3 != 0) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray3, 0, byArray2, n2, n3);
        }
        return byArray2;
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.c) {
            throw new IllegalStateException("not set for wrapping");
        }
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = Pack.intToBigEndian(n3);
        System.arraycopy(this.e, 0, byArray2, 0, this.e.length);
        System.arraycopy(byArray3, 0, byArray2, this.e.length, byArray3.length);
        byte[] byArray4 = new byte[n3];
        System.arraycopy(byArray, n2, byArray4, 0, n3);
        byte[] byArray5 = this.a(byArray4);
        if (byArray5.length == 8) {
            byte[] byArray6 = new byte[byArray5.length + byArray2.length];
            System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
            System.arraycopy(byArray5, 0, byArray6, byArray2.length, byArray5.length);
            this.a.init(true, this.b);
            for (int i2 = 0; i2 < byArray6.length; i2 += this.a.getBlockSize()) {
                this.a.processBlock(byArray6, i2, byArray6, i2);
            }
            return byArray6;
        }
        RFC3394WrapEngine rFC3394WrapEngine = new RFC3394WrapEngine(this.a);
        ParametersWithIV parametersWithIV = new ParametersWithIV(this.b, byArray2);
        rFC3394WrapEngine.init(true, parametersWithIV);
        return rFC3394WrapEngine.wrap(byArray5, 0, byArray5.length);
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        int n5;
        int n6;
        byte[] byArray2;
        if (this.c) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n7 = n3 / 8;
        if (n7 * 8 != n3) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        if (n7 == 1) {
            throw new InvalidCipherTextException("unwrap data must be at least 16 bytes");
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        byte[] byArray4 = new byte[n3];
        if (n7 == 2) {
            this.a.init(false, this.b);
            for (int i2 = 0; i2 < byArray3.length; i2 += this.a.getBlockSize()) {
                this.a.processBlock(byArray3, i2, byArray4, i2);
            }
            this.f = new byte[8];
            System.arraycopy(byArray4, 0, this.f, 0, this.f.length);
            byArray2 = new byte[byArray4.length - this.f.length];
            System.arraycopy(byArray4, this.f.length, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray4 = this.a(byArray, n2, n3);
        }
        byte[] byArray5 = new byte[4];
        byte[] byArray6 = new byte[4];
        System.arraycopy(this.f, 0, byArray5, 0, byArray5.length);
        System.arraycopy(this.f, byArray5.length, byArray6, 0, byArray6.length);
        int n8 = Pack.bigEndianToInt(byArray6, 0);
        boolean bl2 = true;
        if (!Arrays.constantTimeAreEqual(byArray5, this.e)) {
            bl2 = false;
        }
        if (n8 <= (n6 = (n5 = byArray2.length) - 8)) {
            bl2 = false;
        }
        if (n8 > n5) {
            bl2 = false;
        }
        if ((n4 = n5 - n8) >= byArray2.length) {
            bl2 = false;
            n4 = byArray2.length;
        }
        byte[] byArray7 = new byte[n4];
        byte[] byArray8 = new byte[n4];
        System.arraycopy(byArray2, byArray2.length - n4, byArray8, 0, n4);
        if (!Arrays.constantTimeAreEqual(byArray8, byArray7)) {
            bl2 = false;
        }
        if (!bl2) {
            throw new InvalidCipherTextException("checksum failed");
        }
        byte[] byArray9 = new byte[n8];
        System.arraycopy(byArray2, 0, byArray9, 0, byArray9.length);
        return byArray9;
    }

    private byte[] a(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[n3 - byArray2.length];
        byte[] byArray4 = new byte[byArray2.length];
        byte[] byArray5 = new byte[8 + byArray2.length];
        System.arraycopy(byArray, n2, byArray4, 0, byArray2.length);
        System.arraycopy(byArray, n2 + byArray2.length, byArray3, 0, n3 - byArray2.length);
        this.a.init(false, this.b);
        int n4 = n3 / 8;
        --n4;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n4; i3 >= 1; --i3) {
                System.arraycopy(byArray4, 0, byArray5, 0, byArray2.length);
                System.arraycopy(byArray3, 8 * (i3 - 1), byArray5, byArray2.length, 8);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    byte by2 = (byte)n5;
                    int n7 = byArray2.length - n6;
                    byArray5[n7] = (byte)(byArray5[n7] ^ by2);
                    n5 >>>= 8;
                    ++n6;
                }
                this.a.processBlock(byArray5, 0, byArray5, 0);
                System.arraycopy(byArray5, 0, byArray4, 0, 8);
                System.arraycopy(byArray5, 8, byArray3, 8 * (i3 - 1), 8);
            }
        }
        this.f = byArray4;
        return byArray3;
    }
}

