/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.generators;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DSAKeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DSAParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.math.ec.WNafUtil;
import com.aspose.psd.internal.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private DSAKeyGenerationParameters b;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.b = (DSAKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DSAParameters dSAParameters = this.b.getParameters();
        BigInteger bigInteger = DSAKeyPairGenerator.a(dSAParameters.getQ(), this.b.getRandom());
        BigInteger bigInteger2 = DSAKeyPairGenerator.a(dSAParameters.getP(), dSAParameters.getG(), bigInteger);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(bigInteger2, dSAParameters), new DSAPrivateKeyParameters(bigInteger, dSAParameters));
    }

    private static BigInteger a(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2;
        int n2 = bigInteger.bitLength() >>> 2;
        while (WNafUtil.getNafWeight(bigInteger2 = BigIntegers.createRandomInRange(a, bigInteger.subtract(a), secureRandom)) < n2) {
        }
        return bigInteger2;
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger2.modPow(bigInteger3, bigInteger);
    }
}

