/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.generators;

import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Mac;
import com.aspose.psd.internal.bouncycastle.crypto.MacDerivationFunction;
import com.aspose.psd.internal.bouncycastle.crypto.params.KDFFeedbackParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import java.math.BigInteger;

public class KDFFeedbackBytesGenerator
implements MacDerivationFunction {
    private static final BigInteger a = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger b = BigInteger.valueOf(2L);
    private final Mac c;
    private final int d;
    private byte[] e;
    private int f;
    private byte[] g;
    private byte[] h;
    private boolean i;
    private int j;
    private byte[] k;

    public KDFFeedbackBytesGenerator(Mac mac) {
        this.c = mac;
        this.d = mac.getMacSize();
        this.k = new byte[this.d];
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        BigInteger bigInteger;
        if (!(derivationParameters instanceof KDFFeedbackParameters)) {
            throw new IllegalArgumentException("Wrong type of arguments given");
        }
        KDFFeedbackParameters kDFFeedbackParameters = (KDFFeedbackParameters)derivationParameters;
        this.c.init(new KeyParameter(kDFFeedbackParameters.getKI()));
        this.e = kDFFeedbackParameters.getFixedInputData();
        int n2 = kDFFeedbackParameters.getR();
        this.g = new byte[n2 / 8];
        this.f = kDFFeedbackParameters.useCounter() ? ((bigInteger = b.pow(n2).multiply(BigInteger.valueOf(this.d))).compareTo(a) == 1 ? Integer.MAX_VALUE : bigInteger.intValue()) : Integer.MAX_VALUE;
        this.h = kDFFeedbackParameters.getIV();
        this.i = kDFFeedbackParameters.useCounter();
        this.j = 0;
    }

    @Override
    public Mac getMac() {
        return this.c;
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        int n4 = this.j + n3;
        if (n4 < 0 || n4 >= this.f) {
            throw new DataLengthException("Current KDFCTR may only be used for " + this.f + " bytes");
        }
        if (this.j % this.d == 0) {
            this.a();
        }
        int n5 = n3;
        int n6 = this.j % this.d;
        int n7 = this.d - this.j % this.d;
        int n8 = Math.min(n7, n5);
        System.arraycopy(this.k, n6, byArray, n2, n8);
        this.j += n8;
        n5 -= n8;
        n2 += n8;
        while (n5 > 0) {
            this.a();
            n8 = Math.min(this.d, n5);
            System.arraycopy(this.k, 0, byArray, n2, n8);
            this.j += n8;
            n5 -= n8;
            n2 += n8;
        }
        return n3;
    }

    private void a() {
        if (this.j == 0) {
            this.c.update(this.h, 0, this.h.length);
        } else {
            this.c.update(this.k, 0, this.k.length);
        }
        if (this.i) {
            int n2 = this.j / this.d + 1;
            switch (this.g.length) {
                case 4: {
                    this.g[0] = (byte)(n2 >>> 24);
                }
                case 3: {
                    this.g[this.g.length - 3] = (byte)(n2 >>> 16);
                }
                case 2: {
                    this.g[this.g.length - 2] = (byte)(n2 >>> 8);
                }
                case 1: {
                    this.g[this.g.length - 1] = (byte)n2;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported size of counter i");
                }
            }
            this.c.update(this.g, 0, this.g.length);
        }
        this.c.update(this.e, 0, this.e.length);
        this.c.doFinal(this.k, 0);
    }
}

