/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.generators;

import com.aspose.psd.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.psd.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.psd.internal.bouncycastle.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest a;
    private byte[] b;
    private int c;

    public MGF1BytesGenerator(Digest digest) {
        this.a = digest;
        this.c = digest.getDigestSize();
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof MGFParameters)) {
            throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
        }
        MGFParameters mGFParameters = (MGFParameters)derivationParameters;
        this.b = mGFParameters.getSeed();
    }

    public Digest getDigest() {
        return this.a;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n3 < n2) {
            throw new OutputLengthException("output buffer too small");
        }
        byte[] byArray2 = new byte[this.c];
        byte[] byArray3 = new byte[4];
        int n4 = 0;
        this.a.reset();
        if (n3 > this.c) {
            do {
                this.a(n4, byArray3);
                this.a.update(this.b, 0, this.b.length);
                this.a.update(byArray3, 0, byArray3.length);
                this.a.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n2 + n4 * this.c, this.c);
            } while (++n4 < n3 / this.c);
        }
        if (n4 * this.c < n3) {
            this.a(n4, byArray3);
            this.a.update(this.b, 0, this.b.length);
            this.a.update(byArray3, 0, byArray3.length);
            this.a.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n2 + n4 * this.c, n3 - n4 * this.c);
        }
        return n3;
    }
}

