/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.paddings;

import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class ISO7816d4Padding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "ISO7816-4";
    }

    @Override
    public int addPadding(byte[] byArray, int n2) {
        int n3 = byArray.length - n2;
        byArray[n2] = -128;
        ++n2;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            ++n2;
        }
        return n3;
    }

    @Override
    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2;
        for (n2 = byArray.length - 1; n2 > 0 && byArray[n2] == 0; --n2) {
        }
        if (byArray[n2] != -128) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return byArray.length - n2;
    }
}

