/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.prng;

import com.aspose.psd.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.psd.internal.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.aspose.psd.internal.bouncycastle.crypto.prng.EntropySourceProvider;
import com.aspose.psd.internal.bouncycastle.crypto.prng.X931RNG;
import com.aspose.psd.internal.bouncycastle.crypto.prng.X931SecureRandom;
import com.aspose.psd.internal.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class X931SecureRandomBuilder {
    private SecureRandom a;
    private EntropySourceProvider b;
    private byte[] c;

    public X931SecureRandomBuilder() {
        this(new SecureRandom(), false);
    }

    public X931SecureRandomBuilder(SecureRandom secureRandom, boolean bl2) {
        this.a = secureRandom;
        this.b = new BasicEntropySourceProvider(this.a, bl2);
    }

    public X931SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.a = null;
        this.b = entropySourceProvider;
    }

    public X931SecureRandomBuilder setDateTimeVector(byte[] byArray) {
        this.c = byArray;
        return this;
    }

    public X931SecureRandom build(BlockCipher blockCipher, KeyParameter keyParameter, boolean bl2) {
        if (this.c == null) {
            this.c = new byte[blockCipher.getBlockSize()];
            Pack.longToBigEndian(System.currentTimeMillis(), this.c, 0);
        }
        blockCipher.init(true, keyParameter);
        return new X931SecureRandom(this.a, new X931RNG(blockCipher, this.c, this.b.get(blockCipher.getBlockSize() * 8)), bl2);
    }
}

