/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.crypto.signers;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.CryptoException;
import com.aspose.psd.internal.bouncycastle.crypto.Digest;
import com.aspose.psd.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.psd.internal.bouncycastle.crypto.SignerWithRecovery;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.psd.internal.bouncycastle.crypto.params.ParametersWithSalt;
import com.aspose.psd.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.psd.internal.bouncycastle.crypto.signers.ISOTrailers;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class ISO9796d2PSSSigner
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private Digest a;
    private AsymmetricBlockCipher b;
    private SecureRandom c;
    private byte[] d;
    private int e;
    private int f;
    private int g;
    private byte[] h;
    private byte[] i;
    private int j;
    private int k;
    private boolean l;
    private byte[] m;
    private byte[] n;
    private byte[] o;
    private int p;
    private int q;

    public ISO9796d2PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n2, boolean bl2) {
        this.b = asymmetricBlockCipher;
        this.a = digest;
        this.e = digest.getDigestSize();
        this.k = n2;
        if (bl2) {
            this.f = 188;
        } else {
            Integer n3 = ISOTrailers.getTrailer(digest);
            if (n3 != null) {
                this.f = n3;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest: " + digest.getAlgorithmName());
            }
        }
    }

    public ISO9796d2PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n2) {
        this(asymmetricBlockCipher, digest, n2, false);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters;
        int n2 = this.k;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithRandom.getParameters();
            if (bl2) {
                this.c = parametersWithRandom.getRandom();
            }
        } else if (cipherParameters instanceof ParametersWithSalt) {
            ParametersWithSalt parametersWithSalt = (ParametersWithSalt)cipherParameters;
            rSAKeyParameters = (RSAKeyParameters)parametersWithSalt.getParameters();
            this.d = parametersWithSalt.getSalt();
            n2 = this.d.length;
            if (this.d.length != this.k) {
                throw new IllegalArgumentException("Fixed salt is of wrong length");
            }
        } else {
            rSAKeyParameters = (RSAKeyParameters)cipherParameters;
            if (bl2) {
                this.c = new SecureRandom();
            }
        }
        this.b.init(bl2, rSAKeyParameters);
        this.g = rSAKeyParameters.getModulus().bitLength();
        this.h = new byte[(this.g + 7) / 8];
        this.i = this.f == 188 ? new byte[this.h.length - this.a.getDigestSize() - n2 - 1 - 1] : new byte[this.h.length - this.a.getDigestSize() - n2 - 1 - 2];
        this.reset();
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        boolean bl2 = true;
        if (this.j != byArray2.length) {
            bl2 = false;
        }
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            bl2 = false;
        }
        return bl2;
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void updateWithRecoveredMessage(byte[] byArray) throws InvalidCipherTextException {
        int n2;
        Object object;
        int n3;
        byte[] byArray2 = this.b.processBlock(byArray, 0, byArray.length);
        if (byArray2.length < (this.g + 7) / 8) {
            byte[] byArray3 = new byte[(this.g + 7) / 8];
            System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
            this.a(byArray2);
            byArray2 = byArray3;
        }
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n3 = 1;
        } else {
            int n4 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            object = ISOTrailers.getTrailer(this.a);
            if (object != null) {
                n2 = (Integer)object;
                if (n4 != n2 && (n2 != 15052 || n4 != 16588)) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n4);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n3 = 2;
        }
        byte[] byArray4 = new byte[this.e];
        this.a.doFinal(byArray4, 0);
        object = this.a(byArray2, byArray2.length - this.e - n3, this.e, byArray2.length - this.e - n3);
        for (n2 = 0; n2 != ((Object)object).length; ++n2) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ object[n2]);
        }
        byArray2[0] = (byte)(byArray2[0] & 0x7F);
        for (n2 = 0; n2 != byArray2.length && byArray2[n2] != 1; ++n2) {
        }
        if (++n2 >= byArray2.length) {
            this.a(byArray2);
        }
        this.l = n2 > 1;
        this.m = new byte[((Object)object).length - n2 - this.k];
        System.arraycopy(byArray2, n2, this.m, 0, this.m.length);
        System.arraycopy(this.m, 0, this.i, 0, this.m.length);
        this.n = byArray;
        this.o = byArray2;
        this.p = n2;
        this.q = n3;
    }

    @Override
    public void update(byte by2) {
        if (this.n == null && this.j < this.i.length) {
            this.i[this.j++] = by2;
        } else {
            this.a.update(by2);
        }
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (this.n == null) {
            while (n3 > 0 && this.j < this.i.length) {
                this.update(byArray[n2]);
                ++n2;
                --n3;
            }
        }
        if (n3 > 0) {
            this.a.update(byArray, n2, n3);
        }
    }

    @Override
    public void reset() {
        this.a.reset();
        this.j = 0;
        if (this.i != null) {
            this.a(this.i);
        }
        if (this.m != null) {
            this.a(this.m);
            this.m = null;
        }
        this.l = false;
        if (this.n != null) {
            this.n = null;
            this.a(this.o);
            this.o = null;
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        byte[] byArray;
        int n2 = this.a.getDigestSize();
        byte[] byArray2 = new byte[n2];
        this.a.doFinal(byArray2, 0);
        byte[] byArray3 = new byte[8];
        this.a((long)(this.j * 8), byArray3);
        this.a.update(byArray3, 0, byArray3.length);
        this.a.update(this.i, 0, this.j);
        this.a.update(byArray2, 0, byArray2.length);
        if (this.d != null) {
            byArray = this.d;
        } else {
            byArray = new byte[this.k];
            this.c.nextBytes(byArray);
        }
        this.a.update(byArray, 0, byArray.length);
        byte[] byArray4 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray4, 0);
        int n3 = 2;
        if (this.f == 188) {
            n3 = 1;
        }
        int n4 = this.h.length - this.j - byArray.length - this.e - n3 - 1;
        this.h[n4] = 1;
        System.arraycopy(this.i, 0, this.h, n4 + 1, this.j);
        System.arraycopy(byArray, 0, this.h, n4 + 1 + this.j, byArray.length);
        byte[] byArray5 = this.a(byArray4, 0, byArray4.length, this.h.length - this.e - n3);
        for (int i2 = 0; i2 != byArray5.length; ++i2) {
            int n5 = i2;
            this.h[n5] = (byte)(this.h[n5] ^ byArray5[i2]);
        }
        System.arraycopy(byArray4, 0, this.h, this.h.length - this.e - n3, this.e);
        if (this.f == 188) {
            this.h[this.h.length - 1] = -68;
        } else {
            this.h[this.h.length - 2] = (byte)(this.f >>> 8);
            this.h[this.h.length - 1] = (byte)this.f;
        }
        this.h[0] = (byte)(this.h[0] & 0x7F);
        byte[] byArray6 = this.b.processBlock(this.h, 0, this.h.length);
        this.m = new byte[this.j];
        this.l = this.j <= this.i.length;
        System.arraycopy(this.i, 0, this.m, 0, this.m.length);
        this.a(this.i);
        this.a(this.h);
        this.j = 0;
        return byArray6;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        byte[] byArray2 = new byte[this.e];
        this.a.doFinal(byArray2, 0);
        int n2 = 0;
        if (this.n == null) {
            try {
                this.updateWithRecoveredMessage(byArray);
            }
            catch (Exception exception) {
                return false;
            }
        } else if (!Arrays.areEqual(this.n, byArray)) {
            throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
        }
        byte[] byArray3 = this.o;
        n2 = this.p;
        int n3 = this.q;
        this.n = null;
        this.o = null;
        byte[] byArray4 = new byte[8];
        this.a((long)(this.m.length * 8), byArray4);
        this.a.update(byArray4, 0, byArray4.length);
        if (this.m.length != 0) {
            this.a.update(this.m, 0, this.m.length);
        }
        this.a.update(byArray2, 0, byArray2.length);
        if (this.d != null) {
            this.a.update(this.d, 0, this.d.length);
        } else {
            this.a.update(byArray3, n2 + this.m.length, this.k);
        }
        byte[] byArray5 = new byte[this.a.getDigestSize()];
        this.a.doFinal(byArray5, 0);
        int n4 = byArray3.length - n3 - byArray5.length;
        boolean bl2 = true;
        for (int i2 = 0; i2 != byArray5.length; ++i2) {
            if (byArray5[i2] == byArray3[n4 + i2]) continue;
            bl2 = false;
        }
        this.a(byArray3);
        this.a(byArray5);
        if (!bl2) {
            this.l = false;
            this.j = 0;
            this.a(this.m);
            return false;
        }
        if (this.j != 0 && !this.a(this.i, this.m)) {
            this.j = 0;
            this.a(this.i);
            return false;
        }
        this.j = 0;
        this.a(this.i);
        return true;
    }

    @Override
    public boolean hasFullMessage() {
        return this.l;
    }

    @Override
    public byte[] getRecoveredMessage() {
        return this.m;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private void a(long l2, byte[] byArray) {
        byArray[0] = (byte)(l2 >>> 56);
        byArray[1] = (byte)(l2 >>> 48);
        byArray[2] = (byte)(l2 >>> 40);
        byArray[3] = (byte)(l2 >>> 32);
        byArray[4] = (byte)(l2 >>> 24);
        byArray[5] = (byte)(l2 >>> 16);
        byArray[6] = (byte)(l2 >>> 8);
        byArray[7] = (byte)(l2 >>> 0);
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.e];
        byte[] byArray4 = new byte[4];
        this.a.reset();
        for (n5 = 0; n5 < n4 / this.e; ++n5) {
            this.a(n5, byArray4);
            this.a.update(byArray, n2, n3);
            this.a.update(byArray4, 0, byArray4.length);
            this.a.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.e, this.e);
        }
        if (n5 * this.e < n4) {
            this.a(n5, byArray4);
            this.a.update(byArray, n2, n3);
            this.a.update(byArray4, 0, byArray4.length);
            this.a.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.e, byArray2.length - n5 * this.e);
        }
        return byArray2;
    }
}

