/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jce.provider;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.TBSCertificate;
import com.aspose.psd.internal.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.PKIXExtendedParameters;
import com.aspose.psd.internal.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jcajce.util.JcaJceHelper;
import com.aspose.psd.internal.bouncycastle.jce.exception.ExtCertPathValidatorException;
import com.aspose.psd.internal.bouncycastle.jce.provider.AnnotatedException;
import com.aspose.psd.internal.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import com.aspose.psd.internal.bouncycastle.jce.provider.PKIXPolicyNode;
import com.aspose.psd.internal.bouncycastle.jce.provider.c;
import com.aspose.psd.internal.bouncycastle.jce.provider.h;
import com.aspose.psd.internal.bouncycastle.jce.provider.i;
import com.aspose.psd.internal.bouncycastle.x509.ExtendedPKIXParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private final JcaJceHelper a = new BCJcaJceHelper();

    @Override
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Name x500Name;
        TrustAnchor trustAnchor;
        PKIXExtendedParameters pKIXExtendedParameters;
        Object object;
        if (certPathParameters instanceof PKIXParameters) {
            object = new PKIXExtendedParameters.Builder((PKIXParameters)certPathParameters);
            if (certPathParameters instanceof ExtendedPKIXParameters) {
                ExtendedPKIXParameters extendedPKIXParameters = (ExtendedPKIXParameters)certPathParameters;
                ((PKIXExtendedParameters.Builder)object).setUseDeltasEnabled(extendedPKIXParameters.isUseDeltasEnabled());
                ((PKIXExtendedParameters.Builder)object).setValidityModel(extendedPKIXParameters.getValidityModel());
            }
            pKIXExtendedParameters = ((PKIXExtendedParameters.Builder)object).build();
        } else if (certPathParameters instanceof PKIXExtendedBuilderParameters) {
            pKIXExtendedParameters = ((PKIXExtendedBuilderParameters)certPathParameters).getBaseParameters();
        } else if (certPathParameters instanceof PKIXExtendedParameters) {
            pKIXExtendedParameters = (PKIXExtendedParameters)certPathParameters;
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be a " + PKIXParameters.class.getName() + " instance.");
        }
        if (pKIXExtendedParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        object = certPath.getCertificates();
        int n2 = object.size();
        if (object.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = pKIXExtendedParameters.getInitialPolicies();
        try {
            trustAnchor = c.a((X509Certificate)object.get(object.size() - 1), pKIXExtendedParameters.getTrustAnchors(), pKIXExtendedParameters.getSigProvider());
            if (trustAnchor == null) {
                throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
            }
            PKIXCertPathValidatorSpi.checkCertificate(trustAnchor.getTrustedCert());
        }
        catch (AnnotatedException annotatedException) {
            throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, object.size() - 1);
        }
        pKIXExtendedParameters = new PKIXExtendedParameters.Builder(pKIXExtendedParameters).setTrustAnchor(trustAnchor).build();
        int n3 = 0;
        List[] listArray = new ArrayList[n2 + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        HashSet hashSet3 = new HashSet();
        int n4 = pKIXExtendedParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n5 = pKIXExtendedParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n6 = pKIXExtendedParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Name = h.a(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Name = h.a(trustAnchor);
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExtCertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        AlgorithmIdentifier algorithmIdentifier = null;
        try {
            algorithmIdentifier = c.a(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new ExtCertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        int n7 = n2;
        if (pKIXExtendedParameters.getTargetConstraints() != null && !pKIXExtendedParameters.getTargetConstraints().match((X509Certificate)object.get(0))) {
            throw new ExtCertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list = pKIXExtendedParameters.getCertPathCheckers();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n3 = object.size() - 1; n3 >= 0; --n3) {
            int n8 = n2 - n3;
            x509Certificate2 = (X509Certificate)object.get(n3);
            boolean bl2 = n3 == object.size() - 1;
            try {
                PKIXCertPathValidatorSpi.checkCertificate(x509Certificate2);
            }
            catch (AnnotatedException annotatedException) {
                throw new CertPathValidatorException(annotatedException.getMessage(), annotatedException.getUnderlyingException(), certPath, n3);
            }
            i.a(certPath, pKIXExtendedParameters, n3, publicKey, bl2, x500Name, x509Certificate, this.a);
            i.a(certPath, n3, pKIXNameConstraintValidator);
            pKIXPolicyNode = i.a(certPath, n3, hashSet3, pKIXPolicyNode, listArray, n5);
            pKIXPolicyNode = i.a(certPath, n3, pKIXPolicyNode);
            i.a(certPath, n3, pKIXPolicyNode, n4);
            if (n8 == n2) continue;
            if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                if (n8 == 1 && x509Certificate2.equals(trustAnchor.getTrustedCert())) continue;
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n3);
            }
            i.a(certPath, n3);
            pKIXPolicyNode = i.a(certPath, n3, listArray, pKIXPolicyNode, n6);
            i.b(certPath, n3, pKIXNameConstraintValidator);
            n4 = i.f(certPath, n3, n4);
            n6 = i.g(certPath, n3, n6);
            n5 = i.h(certPath, n3, n5);
            n4 = i.a(certPath, n3, n4);
            n6 = i.b(certPath, n3, n6);
            n5 = i.c(certPath, n3, n5);
            i.b(certPath, n3);
            n7 = i.d(certPath, n3, n7);
            n7 = i.e(certPath, n3, n7);
            i.c(certPath, n3);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.remove(i.m);
                hashSet.remove(i.a);
                hashSet.remove(i.b);
                hashSet.remove(i.c);
                hashSet.remove(i.d);
                hashSet.remove(i.f);
                hashSet.remove(i.g);
                hashSet.remove(i.h);
                hashSet.remove(i.j);
                hashSet.remove(i.k);
            } else {
                hashSet = new HashSet();
            }
            i.a(certPath, n3, hashSet, list);
            x509Certificate = x509Certificate2;
            x500Name = h.a(x509Certificate);
            try {
                publicKey = c.a(certPath.getCertificates(), n3, this.a);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n3);
            }
            algorithmIdentifier = c.a(publicKey);
            aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            aSN1Encodable = algorithmIdentifier.getParameters();
        }
        n4 = i.a(n4, x509Certificate2);
        n4 = i.i(certPath, n3 + 1, n4);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.remove(i.m);
            set2.remove(i.a);
            set2.remove(i.b);
            set2.remove(i.c);
            set2.remove(i.d);
            set2.remove(i.f);
            set2.remove(i.g);
            set2.remove(i.h);
            set2.remove(i.j);
            set2.remove(i.k);
            set2.remove(i.i);
            set2.remove(Extension.extendedKeyUsage.getId());
        } else {
            set2 = new HashSet<String>();
        }
        i.a(certPath, n3 + 1, list, set2);
        hashSet = i.a(certPath, pKIXExtendedParameters, set, n3 + 1, listArray, pKIXPolicyNode, hashSet3);
        if (n4 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }

    static void checkCertificate(X509Certificate x509Certificate) throws AnnotatedException {
        try {
            TBSCertificate.getInstance(x509Certificate.getTBSCertificate());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AnnotatedException("unable to process TBSCertificate");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AnnotatedException(illegalArgumentException.getMessage());
        }
    }
}

