/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.jce.provider;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.util.ASN1Dump;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.CRLDistPoint;
import com.aspose.psd.internal.bouncycastle.asn1.x509.CRLNumber;
import com.aspose.psd.internal.bouncycastle.asn1.x509.CertificateList;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extension;
import com.aspose.psd.internal.bouncycastle.asn1.x509.Extensions;
import com.aspose.psd.internal.bouncycastle.asn1.x509.GeneralNames;
import com.aspose.psd.internal.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.aspose.psd.internal.bouncycastle.asn1.x509.TBSCertList;
import com.aspose.psd.internal.bouncycastle.jce.X509Principal;
import com.aspose.psd.internal.bouncycastle.jce.provider.X509CRLEntryObject;
import com.aspose.psd.internal.bouncycastle.jce.provider.e;
import com.aspose.psd.internal.bouncycastle.jce.provider.i;
import com.aspose.psd.internal.bouncycastle.jce.provider.l;
import com.aspose.psd.internal.bouncycastle.util.Strings;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CRLObject
extends X509CRL {
    private CertificateList a;
    private String b;
    private byte[] c;
    private boolean d;
    private boolean e = false;
    private int f;

    public static boolean isIndirectCRL(X509CRL x509CRL) throws CRLException {
        try {
            byte[] byArray = x509CRL.getExtensionValue(Extension.issuingDistributionPoint.getId());
            return byArray != null && IssuingDistributionPoint.getInstance(ASN1OctetString.getInstance(byArray).getOctets()).isIndirectCRL();
        }
        catch (Exception exception) {
            throw new e("Exception reading IssuingDistributionPoint", exception);
        }
    }

    public X509CRLObject(CertificateList certificateList) throws CRLException {
        this.a = certificateList;
        try {
            this.b = l.a(certificateList.getSignatureAlgorithm());
            this.c = (byte[])(certificateList.getSignatureAlgorithm().getParameters() != null ? certificateList.getSignatureAlgorithm().getParameters().toASN1Primitive().getEncoded("DER") : null);
            this.d = X509CRLObject.isIndirectCRL(this);
        }
        catch (Exception exception) {
            throw new CRLException("CRL contents invalid: " + exception);
        }
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set set = this.getCriticalExtensionOIDs();
        if (set == null) {
            return false;
        }
        set.remove(i.d);
        set.remove(i.f);
        return !set.isEmpty();
    }

    private Set a(boolean bl2) {
        Extensions extensions;
        if (this.getVersion() == 2 && (extensions = this.a.getTBSCertList().getExtensions()) != null) {
            HashSet<String> hashSet = new HashSet<String>();
            Enumeration enumeration = extensions.oids();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
                Extension extension = extensions.getExtension(aSN1ObjectIdentifier);
                if (bl2 != extension.isCritical()) continue;
                hashSet.add(aSN1ObjectIdentifier.getId());
            }
            return hashSet;
        }
        return null;
    }

    public Set getCriticalExtensionOIDs() {
        return this.a(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.a(false);
    }

    @Override
    public byte[] getExtensionValue(String string) {
        Extension extension;
        Extensions extensions = this.a.getTBSCertList().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(new ASN1ObjectIdentifier(string))) != null) {
            try {
                return extension.getExtnValue().getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        try {
            return this.a.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public void verify(PublicKey publicKey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        try {
            signature = Signature.getInstance(this.getSigAlgName(), "BC");
        }
        catch (Exception exception) {
            signature = Signature.getInstance(this.getSigAlgName());
        }
        this.a(publicKey, signature);
    }

    @Override
    public void verify(PublicKey publicKey, String string) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature = string != null ? Signature.getInstance(this.getSigAlgName(), string) : Signature.getInstance(this.getSigAlgName());
        this.a(publicKey, signature);
    }

    @Override
    public void verify(PublicKey publicKey, Provider provider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = provider != null ? Signature.getInstance(this.getSigAlgName(), provider) : Signature.getInstance(this.getSigAlgName());
        this.a(publicKey, signature);
    }

    private void a(PublicKey publicKey, Signature signature) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!this.a.getSignatureAlgorithm().equals(this.a.getTBSCertList().getSignature())) {
            throw new CRLException("Signature algorithm on CertificateList does not match TBSCertList.");
        }
        signature.initVerify(publicKey);
        signature.update(this.getTBSCertList());
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("CRL does not verify with supplied public key.");
        }
    }

    @Override
    public int getVersion() {
        return this.a.getVersionNumber();
    }

    @Override
    public Principal getIssuerDN() {
        return new X509Principal(X500Name.getInstance(this.a.getIssuer().toASN1Primitive()));
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            return new X500Principal(this.a.getIssuer().getEncoded());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Date getThisUpdate() {
        return this.a.getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        if (this.a.getNextUpdate() != null) {
            return this.a.getNextUpdate().getDate();
        }
        return null;
    }

    private Set a() {
        HashSet<X509CRLEntryObject> hashSet = new HashSet<X509CRLEntryObject>();
        Enumeration enumeration = this.a.getRevokedCertificateEnumeration();
        X500Name x500Name = null;
        while (enumeration.hasMoreElements()) {
            Extension extension;
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            X509CRLEntryObject x509CRLEntryObject = new X509CRLEntryObject(cRLEntry, this.d, x500Name);
            hashSet.add(x509CRLEntryObject);
            if (!this.d || !cRLEntry.hasExtensions() || (extension = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            x500Name = X500Name.getInstance(GeneralNames.getInstance(extension.getParsedValue()).getNames()[0].getName());
        }
        return hashSet;
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger bigInteger) {
        Enumeration enumeration = this.a.getRevokedCertificateEnumeration();
        X500Name x500Name = null;
        while (enumeration.hasMoreElements()) {
            Extension extension;
            TBSCertList.CRLEntry cRLEntry = (TBSCertList.CRLEntry)enumeration.nextElement();
            if (bigInteger.equals(cRLEntry.getUserCertificate().getValue())) {
                return new X509CRLEntryObject(cRLEntry, this.d, x500Name);
            }
            if (!this.d || !cRLEntry.hasExtensions() || (extension = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) == null) continue;
            x500Name = X500Name.getInstance(GeneralNames.getInstance(extension.getParsedValue()).getNames()[0].getName());
        }
        return null;
    }

    public Set getRevokedCertificates() {
        Set set = this.a();
        if (!set.isEmpty()) {
            return Collections.unmodifiableSet(set);
        }
        return null;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        try {
            return this.a.getTBSCertList().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.a.getSignature().getOctets();
    }

    @Override
    public String getSigAlgName() {
        return this.b;
    }

    @Override
    public String getSigAlgOID() {
        return this.a.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.c != null) {
            byte[] byArray = new byte[this.c.length];
            System.arraycopy(this.c, 0, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public String toString() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("              Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("          This update: ").append(this.getThisUpdate()).append(string);
        stringBuffer.append("          Next update: ").append(this.getNextUpdate()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        stringBuffer.append("            Signature: ").append(new String(Hex.encode(byArray, 0, 20))).append(string);
        for (int i2 = 20; i2 < byArray.length; i2 += 20) {
            if (i2 < byArray.length - 20) {
                stringBuffer.append("                       ").append(new String(Hex.encode(byArray, i2, 20))).append(string);
                continue;
            }
            stringBuffer.append("                       ").append(new String(Hex.encode(byArray, i2, byArray.length - i2))).append(string);
        }
        Extensions extensions = this.a.getTBSCertList().getExtensions();
        if (extensions != null) {
            object2 = extensions.oids();
            if (object2.hasMoreElements()) {
                stringBuffer.append("           Extensions: ").append(string);
            }
            while (object2.hasMoreElements()) {
                object = (ASN1ObjectIdentifier)object2.nextElement();
                Extension extension = extensions.getExtension((ASN1ObjectIdentifier)object);
                if (extension.getExtnValue() != null) {
                    byte[] byArray2 = extension.getExtnValue().getOctets();
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray2);
                    stringBuffer.append("                       critical(").append(extension.isCritical()).append(") ");
                    try {
                        if (((ASN1Primitive)object).equals(Extension.cRLNumber)) {
                            stringBuffer.append(new CRLNumber(ASN1Integer.getInstance(aSN1InputStream.readObject()).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((ASN1Primitive)object).equals(Extension.deltaCRLIndicator)) {
                            stringBuffer.append("Base CRL: " + new CRLNumber(ASN1Integer.getInstance(aSN1InputStream.readObject()).getPositiveValue())).append(string);
                            continue;
                        }
                        if (((ASN1Primitive)object).equals(Extension.issuingDistributionPoint)) {
                            stringBuffer.append(IssuingDistributionPoint.getInstance(aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        if (((ASN1Primitive)object).equals(Extension.cRLDistributionPoints)) {
                            stringBuffer.append(CRLDistPoint.getInstance(aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        if (((ASN1Primitive)object).equals(Extension.freshestCRL)) {
                            stringBuffer.append(CRLDistPoint.getInstance(aSN1InputStream.readObject())).append(string);
                            continue;
                        }
                        stringBuffer.append(((ASN1ObjectIdentifier)object).getId());
                        stringBuffer.append(" value = ").append(ASN1Dump.dumpAsString(aSN1InputStream.readObject())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(((ASN1ObjectIdentifier)object).getId());
                        stringBuffer.append(" value = ").append("*****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        if ((object2 = this.getRevokedCertificates()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next());
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isRevoked(Certificate certificate) {
        if (!certificate.getType().equals("X.509")) {
            throw new RuntimeException("X.509 CRL used with non X.509 Cert");
        }
        Enumeration enumeration = this.a.getRevokedCertificateEnumeration();
        X500Name x500Name = this.a.getIssuer();
        if (enumeration != null) {
            BigInteger bigInteger = ((X509Certificate)certificate).getSerialNumber();
            while (enumeration.hasMoreElements()) {
                ASN1Object aSN1Object;
                TBSCertList.CRLEntry cRLEntry = TBSCertList.CRLEntry.getInstance(enumeration.nextElement());
                if (this.d && cRLEntry.hasExtensions() && (aSN1Object = cRLEntry.getExtensions().getExtension(Extension.certificateIssuer)) != null) {
                    x500Name = X500Name.getInstance(GeneralNames.getInstance(aSN1Object.getParsedValue()).getNames()[0].getName());
                }
                if (!cRLEntry.getUserCertificate().getValue().equals(bigInteger)) continue;
                if (certificate instanceof X509Certificate) {
                    aSN1Object = X500Name.getInstance(((X509Certificate)certificate).getIssuerX500Principal().getEncoded());
                } else {
                    try {
                        aSN1Object = com.aspose.psd.internal.bouncycastle.asn1.x509.Certificate.getInstance(certificate.getEncoded()).getIssuer();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new RuntimeException("Cannot process certificate");
                    }
                }
                return x500Name.equals(aSN1Object);
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof X509CRL)) {
            return false;
        }
        if (object instanceof X509CRLObject) {
            boolean bl2;
            X509CRLObject x509CRLObject = (X509CRLObject)object;
            if (this.e && (bl2 = x509CRLObject.e) && x509CRLObject.f != this.f) {
                return false;
            }
            return this.a.equals(x509CRLObject.a);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.e) {
            this.e = true;
            this.f = super.hashCode();
        }
        return this.f;
    }
}

