/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.math.ec.custom.sec;

import com.aspose.psd.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.psd.internal.bouncycastle.math.ec.ECFieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.ECLookupTable;
import com.aspose.psd.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecP256R1FieldElement;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.SecP256R1Point;
import com.aspose.psd.internal.bouncycastle.math.ec.custom.sec.j;
import com.aspose.psd.internal.bouncycastle.math.raw.Nat256;
import com.aspose.psd.internal.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP256R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q = new BigInteger(1, Hex.decode("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFF"));
    private static final int c = 2;
    protected SecP256R1Point infinity = new SecP256R1Point(this, null, null);

    public SecP256R1Curve() {
        super(q);
        this.a = this.fromBigInteger(new BigInteger(1, Hex.decode("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC")));
        this.b = this.fromBigInteger(new BigInteger(1, Hex.decode("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B")));
        this.order = new BigInteger(1, Hex.decode("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"));
        this.cofactor = BigInteger.valueOf(1L);
        this.coord = 2;
    }

    @Override
    protected ECCurve cloneCurve() {
        return new SecP256R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n2) {
        switch (n2) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP256R1FieldElement(bigInteger);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl2) {
        return new SecP256R1Point((ECCurve)this, eCFieldElement, eCFieldElement2, bl2);
    }

    @Override
    protected ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray, boolean bl2) {
        return new SecP256R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray, bl2);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n2, int n3) {
        int[] nArray = new int[n3 * 8 * 2];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            ECPoint eCPoint = eCPointArray[n2 + i2];
            Nat256.copy(((SecP256R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n4);
            Nat256.copy(((SecP256R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n4 += 8);
            n4 += 8;
        }
        return new j(this, n3, nArray);
    }
}

