/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pkcs;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.Attribute;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.CertificationRequest;
import com.aspose.psd.internal.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import com.aspose.psd.internal.bouncycastle.asn1.x500.X500Name;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifier;
import com.aspose.psd.internal.bouncycastle.operator.ContentVerifierProvider;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCSException;
import com.aspose.psd.internal.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class PKCS10CertificationRequest {
    private static Attribute[] a = new Attribute[0];
    private CertificationRequest b;

    private static CertificationRequest a(byte[] byArray) throws IOException {
        try {
            return CertificationRequest.getInstance(ASN1Primitive.fromByteArray(byArray));
        }
        catch (ClassCastException classCastException) {
            throw new PKCSIOException("malformed data: " + classCastException.getMessage(), classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PKCSIOException("malformed data: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    public PKCS10CertificationRequest(CertificationRequest certificationRequest) {
        this.b = certificationRequest;
    }

    public PKCS10CertificationRequest(byte[] byArray) throws IOException {
        this(PKCS10CertificationRequest.a(byArray));
    }

    public CertificationRequest toASN1Structure() {
        return this.b;
    }

    public X500Name getSubject() {
        return X500Name.getInstance(this.b.getCertificationRequestInfo().getSubject());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.b.getSignatureAlgorithm();
    }

    public byte[] getSignature() {
        return this.b.getSignature().getOctets();
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.b.getCertificationRequestInfo().getSubjectPublicKeyInfo();
    }

    public Attribute[] getAttributes() {
        ASN1Set aSN1Set = this.b.getCertificationRequestInfo().getAttributes();
        if (aSN1Set == null) {
            return a;
        }
        Attribute[] attributeArray = new Attribute[aSN1Set.size()];
        for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
            attributeArray[i2] = Attribute.getInstance(aSN1Set.getObjectAt(i2));
        }
        return attributeArray;
    }

    public Attribute[] getAttributes(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        ASN1Set aSN1Set = this.b.getCertificationRequestInfo().getAttributes();
        if (aSN1Set == null) {
            return a;
        }
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(i2));
            if (!attribute.getAttrType().equals(aSN1ObjectIdentifier)) continue;
            arrayList.add(attribute);
        }
        if (arrayList.size() == 0) {
            return a;
        }
        return arrayList.toArray(new Attribute[arrayList.size()]);
    }

    public byte[] getEncoded() throws IOException {
        return this.b.getEncoded();
    }

    public boolean isSignatureValid(ContentVerifierProvider contentVerifierProvider) throws PKCSException {
        ContentVerifier contentVerifier;
        CertificationRequestInfo certificationRequestInfo = this.b.getCertificationRequestInfo();
        try {
            contentVerifier = contentVerifierProvider.get(this.b.getSignatureAlgorithm());
            OutputStream outputStream = contentVerifier.getOutputStream();
            outputStream.write(certificationRequestInfo.getEncoded("DER"));
            outputStream.close();
        }
        catch (Exception exception) {
            throw new PKCSException("unable to process signature: " + exception.getMessage(), exception);
        }
        return contentVerifier.verify(this.getSignature());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PKCS10CertificationRequest)) {
            return false;
        }
        PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)object;
        return this.toASN1Structure().equals(pKCS10CertificationRequest.toASN1Structure());
    }

    public int hashCode() {
        return this.toASN1Structure().hashCode();
    }
}

