/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.asn1;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import java.math.BigInteger;

public class McEliecePublicKey
extends ASN1Object {
    private final int a;
    private final int b;
    private final GF2Matrix c;

    public McEliecePublicKey(int n2, int n3, GF2Matrix gF2Matrix) {
        this.a = n2;
        this.b = n3;
        this.c = new GF2Matrix(gF2Matrix);
    }

    private McEliecePublicKey(ASN1Sequence aSN1Sequence) {
        BigInteger bigInteger = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue();
        this.a = bigInteger.intValue();
        BigInteger bigInteger2 = ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue();
        this.b = bigInteger2.intValue();
        this.c = new GF2Matrix(((ASN1OctetString)aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public int getN() {
        return this.a;
    }

    public int getT() {
        return this.b;
    }

    public GF2Matrix getG() {
        return new GF2Matrix(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(new DEROctetString(this.c.getEncoded()));
        return new DERSequence(aSN1EncodableVector);
    }

    public static McEliecePublicKey getInstance(Object object) {
        if (object instanceof McEliecePublicKey) {
            return (McEliecePublicKey)object;
        }
        if (object != null) {
            return new McEliecePublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }
}

