/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.asn1;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.psd.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.psd.internal.bouncycastle.asn1.DERSequence;
import com.aspose.psd.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class XMSSKeyParams
extends ASN1Object {
    private final ASN1Integer a;
    private final int b;
    private final AlgorithmIdentifier c;

    public XMSSKeyParams(int n2, AlgorithmIdentifier algorithmIdentifier) {
        this.a = new ASN1Integer(0L);
        this.b = n2;
        this.c = algorithmIdentifier;
    }

    private XMSSKeyParams(ASN1Sequence aSN1Sequence) {
        this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
        this.b = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1)).getValue().intValue();
        this.c = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(2));
    }

    public static XMSSKeyParams getInstance(Object object) {
        if (object instanceof XMSSKeyParams) {
            return (XMSSKeyParams)object;
        }
        if (object != null) {
            return new XMSSKeyParams(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public int getHeight() {
        return this.b;
    }

    public AlgorithmIdentifier getTreeDigest() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new ASN1Integer(this.b));
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

