/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece;

import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.aspose.psd.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2Parameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.GoppaCode;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.aspose.psd.internal.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.security.SecureRandom;

public class McElieceCCA2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";
    private McElieceCCA2KeyGenerationParameters a;
    private int b;
    private int c;
    private int d;
    private int e;
    private SecureRandom f;
    private boolean g = false;

    private void a() {
        McElieceCCA2KeyGenerationParameters mcElieceCCA2KeyGenerationParameters = new McElieceCCA2KeyGenerationParameters(new SecureRandom(), new McElieceCCA2Parameters());
        this.init(mcElieceCCA2KeyGenerationParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.a = (McElieceCCA2KeyGenerationParameters)keyGenerationParameters;
        this.f = new SecureRandom();
        this.b = this.a.getParameters().getM();
        this.c = this.a.getParameters().getN();
        this.d = this.a.getParameters().getT();
        this.e = this.a.getParameters().getFieldPoly();
        this.g = true;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        if (!this.g) {
            this.a();
        }
        GF2mField gF2mField = new GF2mField(this.b, this.e);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(gF2mField, this.d, 'I', this.f);
        GF2Matrix gF2Matrix = GoppaCode.createCanonicalCheckMatrix(gF2mField, polynomialGF2mSmallM);
        GoppaCode.MaMaPe maMaPe = GoppaCode.computeSystematicForm(gF2Matrix, this.f);
        GF2Matrix gF2Matrix2 = maMaPe.getSecondMatrix();
        Permutation permutation = maMaPe.getPermutation();
        GF2Matrix gF2Matrix3 = (GF2Matrix)gF2Matrix2.computeTranspose();
        int n2 = gF2Matrix3.getNumRows();
        McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters = new McElieceCCA2PublicKeyParameters(this.c, this.d, gF2Matrix3, this.a.getParameters().getDigest());
        McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters = new McElieceCCA2PrivateKeyParameters(this.c, n2, gF2mField, polynomialGF2mSmallM, permutation, this.a.getParameters().getDigest());
        return new AsymmetricCipherKeyPair(mcElieceCCA2PublicKeyParameters, mcElieceCCA2PrivateKeyParameters);
    }
}

