/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.psd.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.BDS;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.f;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.h;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.k;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.s;
import com.aspose.psd.internal.bouncycastle.util.Arrays;

public class XMSSMTSigner
implements StateAwareMessageSigner {
    private XMSSMTPrivateKeyParameters a;
    private XMSSMTPrivateKeyParameters b;
    private XMSSMTPublicKeyParameters c;
    private XMSSMTParameters d;
    private XMSSParameters e;
    private f f;
    private boolean g;
    private boolean h;

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            this.h = true;
            this.g = false;
            this.b = this.a = (XMSSMTPrivateKeyParameters)cipherParameters;
            this.d = this.a.getParameters();
            this.e = this.d.getXMSSParameters();
        } else {
            this.h = false;
            this.c = (XMSSMTPublicKeyParameters)cipherParameters;
            this.d = this.c.getParameters();
            this.e = this.d.getXMSSParameters();
        }
        this.f = new f(new h(this.d.getDigest()));
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (this.h) {
            if (this.a == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        if (this.a.getBDSState().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        BDSStateMap bDSStateMap = this.a.getBDSState();
        long l2 = this.a.getIndex();
        int n2 = this.d.getHeight();
        int n3 = this.e.getHeight();
        if (!XMSSUtil.isIndexValid(n2, l2)) {
            throw new IllegalStateException("index out of bounds");
        }
        byte[] byArray2 = this.f.b().d(this.a.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(l2, 32));
        byte[] byArray3 = Arrays.concatenate(byArray2, this.a.getRoot(), XMSSUtil.toBytesBigEndian(l2, this.d.getDigestSize()));
        byte[] byArray4 = this.f.b().c(byArray3, byArray);
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.d).withIndex(l2).withRandom(byArray2).build();
        long l3 = XMSSUtil.getTreeIndex(l2, n3);
        int n4 = XMSSUtil.getLeafIndex(l2, n3);
        this.f.a(new byte[this.d.getDigestSize()], this.a.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n4).build();
        if (bDSStateMap.get(0) == null || n4 == 0) {
            bDSStateMap.put(0, new BDS(this.e, this.a.getPublicSeed(), this.a.getSecretKeySeed(), oTSHashAddress));
        }
        k k2 = this.a(byArray4, oTSHashAddress);
        XMSSReducedSignature xMSSReducedSignature = new XMSSReducedSignature.Builder(this.e).withWOTSPlusSignature(k2).withAuthPath(bDSStateMap.get(0).getAuthenticationPath()).build();
        xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        for (int i2 = 1; i2 < this.d.getLayers(); ++i2) {
            XMSSNode xMSSNode = bDSStateMap.get(i2 - 1).getRoot();
            n4 = XMSSUtil.getLeafIndex(l3, n3);
            l3 = XMSSUtil.getTreeIndex(l3, n3);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n4).build();
            k2 = this.a(xMSSNode.getValue(), oTSHashAddress);
            if (bDSStateMap.get(i2) == null || XMSSUtil.isNewBDSInitNeeded(l2, n3, i2)) {
                bDSStateMap.put(i2, new BDS(this.e, this.a.getPublicSeed(), this.a.getSecretKeySeed(), oTSHashAddress));
            }
            xMSSReducedSignature = new XMSSReducedSignature.Builder(this.e).withWOTSPlusSignature(k2).withAuthPath(bDSStateMap.get(i2).getAuthenticationPath()).build();
            xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        }
        this.g = true;
        if (this.b != null) {
            this.b = this.a = this.b.getNextKey();
        } else {
            this.a = null;
        }
        return xMSSMTSignature.toByteArray();
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            throw new NullPointerException("message == null");
        }
        if (byArray2 == null) {
            throw new NullPointerException("signature == null");
        }
        if (this.c == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.d).withSignature(byArray2).build();
        byte[] byArray3 = Arrays.concatenate(xMSSMTSignature.getRandom(), this.c.getRoot(), XMSSUtil.toBytesBigEndian(xMSSMTSignature.getIndex(), this.d.getDigestSize()));
        byte[] byArray4 = this.f.b().c(byArray3, byArray);
        long l2 = xMSSMTSignature.getIndex();
        int n2 = this.e.getHeight();
        long l3 = XMSSUtil.getTreeIndex(l2, n2);
        int n3 = XMSSUtil.getLeafIndex(l2, n2);
        this.f.a(new byte[this.d.getDigestSize()], this.c.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n3).build();
        XMSSReducedSignature xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(0);
        XMSSNode xMSSNode = s.a(this.f, n2, byArray4, xMSSReducedSignature, oTSHashAddress, n3);
        for (int i2 = 1; i2 < this.d.getLayers(); ++i2) {
            xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(i2);
            n3 = XMSSUtil.getLeafIndex(l3, n2);
            l3 = XMSSUtil.getTreeIndex(l3, n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n3).build();
            xMSSNode = s.a(this.f, n2, xMSSNode.getValue(), xMSSReducedSignature, oTSHashAddress, n3);
        }
        return Arrays.constantTimeAreEqual(xMSSNode.getValue(), this.c.getRoot());
    }

    private k a(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.d.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.f.a(this.f.b(this.a.getSecretKeySeed(), oTSHashAddress), this.a.getPublicSeed());
        return this.f.a(byArray, oTSHashAddress);
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.g) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.a;
            this.a = null;
            this.b = null;
            return xMSSMTPrivateKeyParameters;
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.b.getNextKey();
        this.b = null;
        return xMSSMTPrivateKeyParameters;
    }
}

