/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.psd.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.BDS;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.p;
import com.aspose.psd.internal.bouncycastle.util.Arrays;
import com.aspose.psd.internal.bouncycastle.util.Pack;
import java.io.IOException;

public final class XMSSPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters a;
    private final byte[] b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final BDS f;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true);
        this.a = builder.a;
        if (this.a == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.a.getDigestSize();
        byte[] byArray = builder.h;
        if (byArray != null) {
            if (builder.i == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.a.getHeight();
            int n4 = 4;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            int n10 = Pack.bigEndianToInt(byArray, n9);
            if (!XMSSUtil.isIndexValid(n3, n10)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.b = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
            this.e = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
            BDS bDS = null;
            try {
                bDS = (BDS)XMSSUtil.deserialize(byArray2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            bDS.setXMSS(builder.i);
            bDS.validate();
            if (bDS.getIndex() != n10) {
                throw new IllegalStateException("serialized BDS has wrong index");
            }
            this.f = bDS;
        } else {
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.b = byArray3;
            } else {
                this.b = new byte[n2];
            }
            byte[] byArray4 = builder.d;
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.c = byArray4;
            } else {
                this.c = new byte[n2];
            }
            byte[] byArray5 = builder.e;
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.d = byArray5;
            } else {
                this.d = new byte[n2];
            }
            byte[] byArray6 = builder.f;
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.e = byArray6;
            } else {
                this.e = new byte[n2];
            }
            BDS bDS = builder.g;
            this.f = bDS != null ? bDS : (builder.b < (1 << this.a.getHeight()) - 2 && byArray5 != null && byArray3 != null ? new BDS(this.a, byArray5, byArray3, (OTSHashAddress)new OTSHashAddress.Builder().build(), builder.b) : new BDS(this.a, builder.b));
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.a.getDigestSize();
        int n3 = 4;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n3 + n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        Pack.intToBigEndian(this.f.getIndex(), byArray, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.b, n9 += n3);
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n9 += n4);
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n9 += n5);
        XMSSUtil.copyBytesAtOffset(byArray, this.e, n9 += n6);
        byte[] byArray2 = null;
        try {
            byArray2 = XMSSUtil.serialize(this.f);
        }
        catch (IOException iOException) {
            throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
        }
        return Arrays.concatenate(byArray, byArray2);
    }

    public int getIndex() {
        return this.f.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.b);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.c);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.d);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.e);
    }

    BDS getBDSState() {
        return this.f;
    }

    public XMSSParameters getParameters() {
        return this.a;
    }

    public XMSSPrivateKeyParameters getNextKey() {
        int n2 = this.a.getHeight();
        if (this.getIndex() < (1 << n2) - 1) {
            return new Builder(this.a).withSecretKeySeed(this.b).withSecretKeyPRF(this.c).withPublicSeed(this.d).withRoot(this.e).withBDSState(this.f.getNextState(this.d, this.b, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        }
        return new Builder(this.a).withSecretKeySeed(this.b).withSecretKeyPRF(this.c).withPublicSeed(this.d).withRoot(this.e).withBDSState(new BDS(this.a, this.getIndex() + 1)).build();
    }

    /* synthetic */ XMSSPrivateKeyParameters(Builder builder, p p2) {
        this(builder);
    }

    public static class Builder {
        private final XMSSParameters a;
        private int b = 0;
        private byte[] c = null;
        private byte[] d = null;
        private byte[] e = null;
        private byte[] f = null;
        private BDS g = null;
        private byte[] h = null;
        private XMSSParameters i = null;

        public Builder(XMSSParameters xMSSParameters) {
            this.a = xMSSParameters;
        }

        public Builder withIndex(int n2) {
            this.b = n2;
            return this;
        }

        public Builder withSecretKeySeed(byte[] byArray) {
            this.c = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] byArray) {
            this.d = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withPublicSeed(byte[] byArray) {
            this.e = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withRoot(byte[] byArray) {
            this.f = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withBDSState(BDS bDS) {
            this.g = bDS;
            return this;
        }

        public Builder withPrivateKey(byte[] byArray, XMSSParameters xMSSParameters) {
            this.h = XMSSUtil.cloneArray(byArray);
            this.i = xMSSParameters;
            return this;
        }

        public XMSSPrivateKeyParameters build() {
            return new XMSSPrivateKeyParameters(this, null);
        }
    }
}

