/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss;

import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.r;
import com.aspose.psd.internal.bouncycastle.util.Pack;

public final class XMSSSignature
extends XMSSReducedSignature
implements XMSSStoreableObjectInterface {
    private final int a;
    private final byte[] b;

    private XMSSSignature(Builder builder) {
        super(builder);
        this.a = builder.b;
        int n2 = this.getParams().getDigestSize();
        byte[] byArray = builder.c;
        if (byArray != null) {
            if (byArray.length != n2) {
                throw new IllegalArgumentException("size of random needs to be equal to size of digest");
            }
            this.b = byArray;
        } else {
            this.b = new byte[n2];
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2;
        int n3 = this.getParams().getDigestSize();
        int n4 = 4;
        int n5 = n3;
        int n6 = this.getParams().getWOTSPlus().a().e() * n3;
        int n7 = this.getParams().getHeight() * n3;
        int n8 = n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        Pack.intToBigEndian(this.a, byArray, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.b, n9 += n4);
        n9 += n5;
        byte[][] byArray2 = this.getWOTSPlusSignature().a();
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            XMSSUtil.copyBytesAtOffset(byArray, byArray2[n2], n9);
            n9 += n3;
        }
        for (n2 = 0; n2 < this.getAuthPath().size(); ++n2) {
            byte[] byArray3 = this.getAuthPath().get(n2).getValue();
            XMSSUtil.copyBytesAtOffset(byArray, byArray3, n9);
            n9 += n3;
        }
        return byArray;
    }

    public int getIndex() {
        return this.a;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.b);
    }

    /* synthetic */ XMSSSignature(Builder builder, r r2) {
        this(builder);
    }

    public static class Builder
    extends XMSSReducedSignature.Builder {
        private final XMSSParameters a;
        private int b = 0;
        private byte[] c = null;

        public Builder(XMSSParameters xMSSParameters) {
            super(xMSSParameters);
            this.a = xMSSParameters;
        }

        public Builder withIndex(int n2) {
            this.b = n2;
            return this;
        }

        public Builder withRandom(byte[] byArray) {
            this.c = XMSSUtil.cloneArray(byArray);
            return this;
        }

        public Builder withSignature(byte[] byArray) {
            if (byArray == null) {
                throw new NullPointerException("signature == null");
            }
            int n2 = this.a.getDigestSize();
            int n3 = this.a.getWOTSPlus().a().e();
            int n4 = this.a.getHeight();
            int n5 = 4;
            int n6 = n2;
            int n7 = n3 * n2;
            int n8 = n4 * n2;
            int n9 = 0;
            this.b = Pack.bigEndianToInt(byArray, n9);
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
            this.withReducedSignature(XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7 + n8));
            return this;
        }

        @Override
        public XMSSSignature build() {
            return new XMSSSignature(this, null);
        }
    }
}

