/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss;

import com.aspose.psd.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.psd.internal.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.aspose.psd.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA256Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHA512Digest;
import com.aspose.psd.internal.bouncycastle.crypto.digests.SHAKEDigest;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSKeyPairGenerator;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPrivateKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.provider.xmss.BCXMSSPublicKey;
import com.aspose.psd.internal.bouncycastle.pqc.jcajce.spec.XMSSParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class XMSSKeyPairGeneratorSpi
extends KeyPairGenerator {
    private XMSSKeyGenerationParameters a;
    private ASN1ObjectIdentifier b;
    private XMSSKeyPairGenerator c = new XMSSKeyPairGenerator();
    private SecureRandom d = new SecureRandom();
    private boolean e = false;

    public XMSSKeyPairGeneratorSpi() {
        super("XMSS");
    }

    @Override
    public void initialize(int n2, SecureRandom secureRandom) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof XMSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a XMSSParameterSpec");
        }
        XMSSParameterSpec xMSSParameterSpec = (XMSSParameterSpec)algorithmParameterSpec;
        if (xMSSParameterSpec.getTreeDigest().equals("SHA256")) {
            this.b = NISTObjectIdentifiers.id_sha256;
            this.a = new XMSSKeyGenerationParameters(new XMSSParameters(xMSSParameterSpec.getHeight(), new SHA256Digest()), secureRandom);
        } else if (xMSSParameterSpec.getTreeDigest().equals("SHA512")) {
            this.b = NISTObjectIdentifiers.id_sha512;
            this.a = new XMSSKeyGenerationParameters(new XMSSParameters(xMSSParameterSpec.getHeight(), new SHA512Digest()), secureRandom);
        } else if (xMSSParameterSpec.getTreeDigest().equals("SHAKE128")) {
            this.b = NISTObjectIdentifiers.id_shake128;
            this.a = new XMSSKeyGenerationParameters(new XMSSParameters(xMSSParameterSpec.getHeight(), new SHAKEDigest(128)), secureRandom);
        } else if (xMSSParameterSpec.getTreeDigest().equals("SHAKE256")) {
            this.b = NISTObjectIdentifiers.id_shake256;
            this.a = new XMSSKeyGenerationParameters(new XMSSParameters(xMSSParameterSpec.getHeight(), new SHAKEDigest(256)), secureRandom);
        }
        this.c.init(this.a);
        this.e = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.e) {
            this.a = new XMSSKeyGenerationParameters(new XMSSParameters(10, new SHA512Digest()), this.d);
            this.c.init(this.a);
            this.e = true;
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.c.generateKeyPair();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = (XMSSPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = (XMSSPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCXMSSPublicKey(this.b, xMSSPublicKeyParameters), new BCXMSSPrivateKey(this.b, xMSSPrivateKeyParameters));
    }
}

