/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.psd.xmp.schemas.photoshop;

import com.aspose.psd.coreexceptions.XmpException;
import com.aspose.psd.internal.Exceptions.ArgumentNullException;
import com.aspose.psd.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.psd.internal.Exceptions.NotImplementedException;
import com.aspose.psd.internal.bG.Q;
import com.aspose.psd.internal.bG.aV;
import com.aspose.psd.internal.gK.h;
import com.aspose.psd.internal.lo.b;
import com.aspose.psd.xmp.XmpArray;
import com.aspose.psd.xmp.XmpPackage;
import com.aspose.psd.xmp.schemas.photoshop.Layer;
import com.aspose.psd.xmp.types.basic.XmpDate;
import com.aspose.psd.xmp.types.basic.XmpInteger;
import com.aspose.psd.xmp.types.basic.XmpText;
import java.util.Date;

public final class PhotoshopPackage
extends XmpPackage {
    public static final int UrgencyMax = 8;
    public static final int UrgencyMin = 1;
    private static final h a = new h("photoshop:urgency", "photoshop:colorMode");

    public PhotoshopPackage() {
        super("photoshop", "http://ns.adobe.com/photoshop/1.0/");
    }

    @Override
    public void addValue(String key, String value) {
        if (aV.b(key)) {
            throw new ArgumentNullException("key", "Photoshop property could not be null");
        }
        switch (a.a(aV.g(key))) {
            case 0: {
                this.setXmpInteger(key, value);
                break;
            }
            case 1: {
                throw new XmpException("Color mode should be recognized before");
            }
            default: {
                super.addValue(key, value);
            }
        }
    }

    public void setAuthorsPosition(String authorsPosition) {
        this.setXmpTypeValue(b.a, new XmpText(authorsPosition));
    }

    public void setCaptionWriter(String captionWriter) {
        this.setXmpTypeValue(b.b, new XmpText(captionWriter));
    }

    public void setCategory(String category) {
        if (!aV.b(category) && category.length() > 3) {
            throw new ArgumentOutOfRangeException("category", "Category is limited to 3 characters");
        }
        this.setXmpTypeValue(b.c, new XmpText(category));
    }

    public void setCity(String city) {
        this.setXmpTypeValue(b.d, new XmpText(city));
    }

    public void setColorMode(byte colorMode) {
        this.setXmpTypeValue(b.e, new XmpInteger(colorMode));
    }

    public void setCountry(String country) {
        this.setXmpTypeValue(b.f, new XmpText(country));
    }

    public void setCredit(String credit) {
        this.setXmpTypeValue(b.g, new XmpText(credit));
    }

    public void setCreatedDate(Date createdDate) {
        this.a(Q.a(createdDate));
    }

    public void a(Q q2) {
        this.setXmpTypeValue(b.h, XmpDate.a(q2));
    }

    public void setDocumentAncestors(String[] ancestors) {
        XmpArray xmpArray = new XmpArray(0, ancestors);
        this.setValue(b.i, xmpArray);
    }

    public void setHeadline(String headline) {
        this.setXmpTypeValue(b.j, new XmpText(headline));
    }

    public void setHistory(String history) {
        this.setXmpTypeValue(b.k, new XmpText(history));
    }

    public void setIccProfile(String iccProfile) {
        this.setXmpTypeValue(b.l, new XmpText(iccProfile));
    }

    public void setInstructions(String instructions) {
        this.setXmpTypeValue(b.m, new XmpText(instructions));
    }

    public void setSource(String source) {
        this.setXmpTypeValue(b.n, new XmpText(source));
    }

    public void setState(String state) {
        this.setXmpTypeValue(b.o, new XmpText(state));
    }

    public void setSupplementalCategories(String[] supplementalCategories) {
        XmpArray xmpArray = new XmpArray(0, supplementalCategories);
        this.setValue(b.p, xmpArray);
    }

    void setLayers(Layer[] layers) {
        throw new NotImplementedException();
    }

    public void setTransmissionReference(String transmissionReference) {
        this.setXmpTypeValue(b.r, new XmpText(transmissionReference));
    }

    public void setUrgency(int urgency) {
        if (urgency < 1 || urgency > 8) {
            throw new ArgumentOutOfRangeException("urgency", aV.a("Valid range is from {0} to {1}", new Object[]{1, 8}));
        }
        this.setXmpTypeValue(b.s, new XmpInteger(urgency));
    }
}

