/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.ny.ds;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.ba;
import com.aspose.slides.ms.System.bm;
import com.aspose.slides.ms.System.eu;
import com.aspose.slides.ms.System.ku;
import com.aspose.slides.ms.System.u6;
import com.aspose.slides.ms.System.v2;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@v5
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] v2;
    private int hn;
    private int cl;
    private final Object v8 = new Object();
    static Object[] cc = new Object[0];

    public List() {
        this.v2 = cc;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.v2 = cc;
        this.v2(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.v2 = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.v2 = data;
        this.hn = size;
    }

    protected int getVersion() {
        return this.cl;
    }

    @Override
    public void addItem(T item) {
        if (this.hn == this.v2.length) {
            this.v2(1);
        }
        this.v2[this.hn++] = item;
        ++this.cl;
    }

    private void v2(int n) {
        int n10 = this.hn + n;
        if (n10 > this.v2.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void v2(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.hn & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void v2(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.v2(new List<T>(collection));
        ++this.cl;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.cl;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return ba.v2(this.v2, 0, this.hn, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return ba.v2(this.v2, 0, this.hn, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.v2(index, count);
        return ba.v2(this.v2, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.v8.v2(this.v2, 0, this.v2.length);
        this.hn = 0;
        ++this.cl;
    }

    public <TOutput> List<TOutput> convertAll(eu<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.hn);
        for (int i = 0; i < this.hn; ++i) {
            list.v2[i] = converter.v2(this.v2[i]);
        }
        list.hn = this.hn;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.v8.v2(this.v2, 0, array, 0, this.hn);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.v8.v2(this.v2, 0, array, arrayIndex, this.hn);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.v2(index, count);
        com.aspose.slides.ms.System.v8.v2(this.v2, index, array, arrayIndex, count);
    }

    public boolean exists(u6<T> match) {
        List.v2(match);
        return this.v2(0, this.hn, match) != -1;
    }

    public T find(u6<T> match) {
        List.v2(match);
        int n = this.v2(0, this.hn, match);
        return (T)(n != -1 ? this.v2[n] : null);
    }

    static <T> void v2(u6<T> u62) {
        if (u62 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(u6<T> match) {
        List.v2(match);
        return this.hn(match);
    }

    private List<T> hn(u6<T> u62) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.hn; ++i) {
            if (!u62.invoke(this.v2[i])) continue;
            list.addItem(this.v2[i]);
        }
        return list;
    }

    public int findIndex(u6<T> match) {
        List.v2(match);
        return this.v2(0, this.hn, match);
    }

    public int findIndex(int startIndex, u6<T> match) {
        List.v2(match);
        this.hn(startIndex);
        return this.v2(startIndex, this.hn - startIndex, match);
    }

    public int findIndex(int startIndex, int count, u6<T> match) {
        List.v2(match);
        this.v2(startIndex, count);
        return this.v2(startIndex, count, match);
    }

    private int v2(int n, int n10, u6<T> u62) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!u62.invoke(this.v2[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(u6<T> match) {
        List.v2(match);
        int n = this.hn(0, this.hn, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(u6<T> match) {
        List.v2(match);
        return this.hn(0, this.hn, match);
    }

    public int findLastIndex(int startIndex, u6<T> match) {
        List.v2(match);
        this.hn(startIndex);
        return this.hn(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, u6<T> match) {
        List.v2(match);
        int n = startIndex - count + 1;
        this.v2(n, count);
        return this.hn(n, count, match);
    }

    private int hn(int n, int n10, u6<T> u62) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!u62.invoke(this.v2[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(v2<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.hn; ++i) {
            action.invoke(this.v2[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.v2(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.v8.v2(this.v2, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.v8.v2(this.v2, item, 0, this.hn);
    }

    public int indexOf(T item, int index) {
        this.hn(index);
        return com.aspose.slides.ms.System.v8.v2(this.v2, item, index, this.hn - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.hn & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.v8.v2(this.v2, item, index, count);
    }

    private void hn(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.hn) {
            com.aspose.slides.ms.System.v8.v2(this.v2, n, this.v2, n + n10, this.hn - n);
        }
        this.hn += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.v8.v2(this.v2, this.hn, -n10);
        }
    }

    private void hn(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.hn & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.hn(index);
        if (this.hn == this.v2.length) {
            this.v2(1);
        }
        this.hn(index, 1);
        this.v2[index] = item;
        ++this.cl;
    }

    void cl(int n) {
        Object[] objectArray = new Object[this.hn];
        this.copyToTArray(objectArray, 0);
        this.v2(this.hn);
        this.hn(n, objectArray.length);
        com.aspose.slides.ms.System.v8.v2(objectArray, 0, this.v2, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.hn(index);
        if (collection == this) {
            this.cl(index);
        } else {
            this.v2(index, collection);
        }
        ++this.cl;
    }

    private void v2(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.hn == 0) {
            return -1;
        }
        return ba.v2(this.v2, item, this.hn - 1, this.hn);
    }

    public int lastIndexOf(T item, int index) {
        this.hn(index);
        return ba.v2(this.v2, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return ba.v2(this.v2, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(u6<T> match) {
        List.v2(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.hn && !match.invoke(this.v2[n]); ++n) {
        }
        if (n == this.hn) {
            return 0;
        }
        ++this.cl;
        for (n10 = n + 1; n10 < this.hn; ++n10) {
            if (match.invoke(this.v2[n10])) continue;
            this.v2[n++] = this.v2[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.v8.v2(this.v2, n, n10 - n);
        }
        this.hn = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.hn & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.hn(index, -1);
        com.aspose.slides.ms.System.v8.v2(this.v2, this.hn, 1);
        ++this.cl;
    }

    public void removeRange(int index, int count) {
        this.v2(index, count);
        if (count > 0) {
            this.hn(index, -count);
            com.aspose.slides.ms.System.v8.v2(this.v2, this.hn, count);
            ++this.cl;
        }
    }

    public void reverse() {
        ba.v2(this.v2, 0, this.hn);
        ++this.cl;
    }

    public void reverse(int index, int count) {
        this.v2(index, count);
        ba.v2(this.v2, index, count);
        ++this.cl;
    }

    public void sort() {
        Arrays.sort(this.v2, 0, this.hn);
        ++this.cl;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.v2, 0, this.hn, comparer);
        ++this.cl;
    }

    @Override
    public void sort(ku<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.v2, 0, this.hn, new ba.v2<T>(comparison));
        ++this.cl;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.v2(index, count);
        Arrays.sort(this.v2, index, index + count, comparer);
        ++this.cl;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.hn) {
            return Arrays.copyOf(this.v2, this.hn, a.getClass());
        }
        System.arraycopy(this.v2, 0, a, 0, this.hn);
        if (a.length > this.hn) {
            a[this.hn] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.hn);
    }

    public boolean trueForAll(u6<T> match) {
        List.v2(match);
        for (int i = 0; i < this.hn; ++i) {
            if (match.invoke(this.v2[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.v2.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.hn & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.v2 = Arrays.copyOf(this.v2, value);
    }

    @Override
    public int size() {
        return this.hn;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.hn & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.v2[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.hn(index);
        if ((long)index == (long)this.hn) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.v2[index] = value;
        ++this.cl;
    }

    public void copyTo(v8 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.v8() > 1 || array.hn(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.v8.v2(com.aspose.slides.ms.System.v8.v2(this.v2), 0, array, arrayIndex, this.hn);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.v8;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.hn == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.hn; ++i) {
                if (this.v2[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.hn; ++i) {
            if (!this.v2[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.hn; ++i) {
                if (this.v2[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.hn; ++i) {
            if (!this.v2[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.hn];
        System.arraycopy(this.v2, 0, objectArray, 0, this.hn);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.hn;
        this.addItem(t);
        return n != this.hn;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.hn;
        this.removeItem(o);
        return n != this.hn;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.hn; ++i) {
                if (this.v2[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.hn; ++i) {
            if (!o.equals(this.v2[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        List<T> list = this.getRange(fromIndex, n);
        return list;
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> v2;
        private int hn;

        public ListInternalized() {
            this.v2 = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.v2 = list;
        }

        @Override
        protected int getVersion() {
            return this.hn;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.v2(collection);
            ++this.hn;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.hn;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return ba.v2(this.v2.toArray(), 0, this.v2.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return ba.v2(this.v2.toArray(), 0, this.v2.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.v2(index, count);
            return ba.v2(this.v2.toArray(), index, count, item, comparer);
        }

        @Override
        private void v2(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.v2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(eu<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.v2.size());
            for (int i = 0; i < this.v2.size(); ++i) {
                list.v2[i] = converter.v2(this.get_Item(i));
            }
            list.hn = this.v2.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.v8.v2(this.v2.toArray(), 0, array, 0, this.v2.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.v8.v2(this.v2.toArray(), 0, array, arrayIndex, this.v2.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.v2(index, count);
            com.aspose.slides.ms.System.v8.v2(this.v2.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(u6<T> match) {
            ListInternalized.hn(match);
            return this.v2(0, this.v2.size(), match) != -1;
        }

        @Override
        private int v2(int n, int n10, u6<T> u62) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!u62.invoke(this.v2.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void hn(u6<T> u62) {
            if (u62 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(u6<T> match) {
            ListInternalized.hn(match);
            int n = this.v2(0, this.v2.size(), match);
            return n != -1 ? (T)this.v2.get(n) : null;
        }

        @Override
        public List<T> findAll(u6<T> match) {
            ListInternalized.hn(match);
            return this.cl(match);
        }

        private List<T> cl(u6<T> u62) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!u62.invoke(this.v2.get(i))) continue;
                list.addItem(this.v2.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(u6<T> match) {
            ListInternalized.hn(match);
            return this.v2(0, this.v2.size(), match);
        }

        @Override
        public int findIndex(int startIndex, u6<T> match) {
            ListInternalized.hn(match);
            this.v2(startIndex);
            return this.v2(startIndex, this.v2.size() - startIndex, match);
        }

        @Override
        private void v2(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.v2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, u6<T> match) {
            ListInternalized.hn(match);
            this.v2(startIndex, count);
            return this.v2(startIndex, count, match);
        }

        @Override
        public T findLast(u6<T> match) {
            ListInternalized.hn(match);
            int n = this.hn(0, this.v2.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int hn(int n, int n10, u6<T> u62) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!u62.invoke(this.v2.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(u6<T> match) {
            ListInternalized.hn(match);
            return this.hn(0, this.v2.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, u6<T> match) {
            ListInternalized.hn(match);
            this.v2(startIndex);
            return this.hn(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, u6<T> match) {
            ListInternalized.hn(match);
            int n = startIndex - count + 1;
            this.v2(n, count);
            return this.hn(n, count, match);
        }

        @Override
        public void forEach(v2<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.v2.size(); ++i) {
                action.invoke(this.v2.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.v2(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.v8.v2(this.v2.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.v2.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.v2(index);
            return com.aspose.slides.ms.System.v8.v2(this.v2.toArray(), item, index, this.v2.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.v2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.v8.v2(this.v2.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.v2.size() == 0) {
                return -1;
            }
            return ba.v2(this.v2.toArray(), item, this.v2.size() - 1, this.v2.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.v2(index);
            return ba.v2(this.v2.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return ba.v2(this.v2.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.v2.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.v2.size());
        }

        @Override
        public boolean trueForAll(u6<T> match) {
            ListInternalized.hn(match);
            for (int i = 0; i < this.v2.size(); ++i) {
                if (match.invoke(this.v2.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.v2.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.v2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.v2.size(); ++i) {
                this.v2.add(null);
            }
        }

        @Override
        public int size() {
            return this.v2.size();
        }

        @Override
        public T get_Item(int index) {
            return this.v2.get(index);
        }

        @Override
        public void copyTo(v8 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.v8() > 1 || array.hn(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.v8.v2(com.aspose.slides.ms.System.v8.v2(this.v2.toArray()), 0, array, arrayIndex, this.v2.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.v2.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.v2.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.v2.size(); ++i) {
                    if (this.v2.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.v2.size(); ++i) {
                if (!this.v2.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.v2.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.hn;
            return this.v2.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.hn;
            return this.v2.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.v2.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.hn;
            return this.v2.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.hn;
            return this.v2.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.hn;
            return this.v2.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.hn;
            return this.v2.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.v2.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.hn;
            return this.v2.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.hn;
            this.v2.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.hn;
            return this.v2.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.v2.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.v2.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.v2.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.v2.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.v2.add(item);
            ++this.hn;
        }

        @Override
        public void clear() {
            this.v2.clear();
            ++this.hn;
        }

        @Override
        public void insertItem(int index, T item) {
            this.v2.add(index, item);
            ++this.hn;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.v2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.v2.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.v2.add(n++, e);
                }
            }
            ++this.hn;
        }

        @Override
        public int removeAll(u6<T> match) {
            ListInternalized.hn(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.v2.size() && !match.invoke(this.v2.get(n)); ++n) {
            }
            if (n == this.v2.size()) {
                return 0;
            }
            ++this.hn;
            for (n10 = n + 1; n10 < this.v2.size(); ++n10) {
                if (match.invoke(this.v2.get(n10))) continue;
                this.v2.set(n++, this.v2.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.v2.remove(this.v2.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.v2.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.v2.remove(index);
            ++this.hn;
        }

        @Override
        public void removeRange(int index, int count) {
            this.v2(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.v2.remove(index);
                }
                ++this.hn;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.v2(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.v2.get(n);
                this.v2.set(n, this.v2.get(i));
                this.v2.set(i, t);
            }
            ++this.hn;
        }

        @Override
        public void sort() {
            Collections.sort(this.v2, null);
            ++this.hn;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.v2, comparer);
            ++this.hn;
        }

        @Override
        public void sort(final ku<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.v2, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.v2(o12, o22);
                }
            });
            ++this.hn;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.v2(index, count);
            java.util.List<T> list = this.v2.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.v2.set(index + i, list.get(i));
            }
            ++this.hn;
        }

        @Override
        public void set_Item(int index, T value) {
            this.v2(index);
            if ((long)index == (long)this.v2.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.v2.set(index, value);
            ++this.hn;
        }

        @Override
        private void v2(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @v5
    public static class EnumeratorJava<T>
    extends ds<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> hn = new List();
        private int cl;
        private int v8;
        private T s0;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.hn = l;
            this.v8 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void v2() {
            if (this.v8 != this.hn.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.cl < 0 || this.cl >= this.hn.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.v8 != this.hn.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.s0 = this.hn.get_Item(this.cl++);
            return this.s0;
        }

        @Override
        public boolean hasNext() {
            if (this.v8 == this.hn.getVersion()) {
                if (this.cl < 0) {
                    return false;
                }
                return this.cl < this.hn.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.v2();
            this.cl = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.hn = this.hn;
            that.cl = this.cl;
            that.v8 = this.v8;
            that.s0 = this.s0;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean v2(EnumeratorJava enumeratorJava) {
            return bm.v2(enumeratorJava.hn, this.hn) && enumeratorJava.cl == this.cl && enumeratorJava.v8 == this.v8 && bm.v2(enumeratorJava.s0, this.s0);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.v2((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.hn != null ? this.hn.hashCode() : 0;
            n = 31 * n + this.cl;
            n = 31 * n + this.v8;
            n = 31 * n + (this.s0 != null ? this.s0.hashCode() : 0);
            return n;
        }
    }

    @v5
    public static class Enumerator<T>
    extends ds<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> hn = new List();
        private int cl;
        private int v8;
        private T s0;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.hn = l;
            this.v8 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void v2() {
            if (this.v8 != this.hn.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.v8 == this.hn.getVersion()) {
                if (this.cl < 0) {
                    return false;
                }
                if (this.cl < this.hn.size()) {
                    this.s0 = this.hn.get_Item(this.cl++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.cl = this.hn.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.v2();
            this.cl = 0;
        }

        @Override
        public T next() {
            if (this.cl < 0 || this.cl >= this.hn.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.s0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.hn = this.hn;
            that.cl = this.cl;
            that.v8 = this.v8;
            that.s0 = this.s0;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean v2(Enumerator enumerator) {
            return bm.v2(enumerator.hn, this.hn) && enumerator.cl == this.cl && enumerator.v8 == this.v8 && bm.v2(enumerator.s0, this.s0);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (bm.hn(null, obj)) {
                return false;
            }
            if (bm.hn(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.v2((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.hn != null ? this.hn.hashCode() : 0;
            n = 31 * n + this.cl;
            n = 31 * n + this.v8;
            n = 31 * n + (this.s0 != null ? this.s0.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.v2 = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.v2 != 0;
        }

        @Override
        public int nextIndex() {
            return this.v2;
        }

        @Override
        public int previousIndex() {
            return this.v2 - 1;
        }

        public T previous() {
            int n = this.v2 - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.v2;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.v2 = n;
            this.hn = n;
            return objectArray[this.hn];
        }

        public void set(T e) {
            if (this.hn < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.hn, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.v2;
                List.this.add(n, e);
                this.v2 = n + 1;
                this.hn = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int v2;
        int hn = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.v2 != List.this.hn;
        }

        @Override
        public T next() {
            int n = this.v2;
            if (n >= List.this.hn) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.v2;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.v2 = n + 1;
            this.hn = n;
            return (T)objectArray[this.hn];
        }

        @Override
        public void remove() {
            if (this.hn < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.hn);
                this.v2 = this.hn;
                this.hn = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

