/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.ba;
import com.aspose.slides.ms.System.v5;
import com.aspose.slides.ms.System.v8;
import com.aspose.slides.ms.System.wp;
import java.util.Arrays;

@v5
public class Stack
implements ICollection,
IEnumerable,
wp {
    private Object[] v2;
    private int hn = -1;
    private int cl;
    private int v8;
    private int s0;

    private void v2(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.v8.v2(this.v2, 0, objectArray, 0, this.cl);
        this.v8 = n;
        this.v2 = objectArray;
    }

    public Stack() {
        this.v2 = new Object[16];
        this.v8 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.v8 = initialCapacity;
        this.v2 = new Object[this.v8];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.cl;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.s0;
        for (int i = 0; i < this.cl; ++i) {
            this.v2[i] = null;
        }
        this.cl = 0;
        this.hn = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.v8.v2(this.v2));
        stack.hn = this.hn;
        stack.cl = this.cl;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.cl == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.cl; ++i) {
                if (this.v2[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.cl; ++i) {
                if (!obj.equals(this.v2[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(v8 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.v8() > 1 || array.s0() > 0 && index >= array.s0() || this.cl > array.s0() - index) {
            throw new ArgumentException();
        }
        for (int i = this.hn; i != -1; --i) {
            array.cl(this.v2[i], this.cl - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.hn == -1) {
            throw new InvalidOperationException();
        }
        return this.v2[this.hn];
    }

    public Object pop() {
        if (this.hn == -1) {
            throw new InvalidOperationException();
        }
        ++this.s0;
        Object object = this.v2[this.hn];
        this.v2[this.hn] = null;
        --this.cl;
        --this.hn;
        if (this.cl <= this.v8 / 4 && this.cl > 16) {
            this.v2(this.v8 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.s0;
        if (this.v8 == this.cl) {
            this.v2(this.v8 * 2);
        }
        ++this.cl;
        ++this.hn;
        this.v2[this.hn] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.cl) {
            a = Arrays.copyOf(this.v2, this.cl, a.getClass());
            ba.v2(a);
            return a;
        }
        System.arraycopy(this.v2, 0, a, 0, this.cl);
        if (a.length > this.cl) {
            a[this.cl] = null;
        }
        ba.v2(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    wp,
    Cloneable {
        private Stack v2;
        private int hn;
        private int cl;

        Enumerator(Stack s) {
            this.v2 = s;
            this.hn = s.s0;
            this.cl = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.v2();
        }

        @Override
        public Object next() {
            if (this.hn != this.v2.s0 || this.cl == -2 || this.cl == -1 || this.cl > this.v2.cl) {
                throw new InvalidOperationException();
            }
            return this.v2.v2[this.cl];
        }

        @Override
        public boolean hasNext() {
            if (this.hn != this.v2.s0) {
                throw new InvalidOperationException();
            }
            switch (this.cl) {
                case -2: {
                    this.cl = this.v2.hn;
                    return this.cl != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.cl;
            return this.cl != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.hn != this.v2.s0) {
                throw new InvalidOperationException();
            }
            this.cl = -2;
        }

        protected Object v2() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.v2 = this.v2;
            enumerator.hn = this.hn;
            enumerator.cl = this.cl;
            return enumerator;
        }
    }

    @v5
    private static class SyncStack
    extends Stack {
        private final Stack v2;

        SyncStack(Stack s) {
            this.v2 = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.v2;
            synchronized (stack) {
                return this.v2.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.v2.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.v2;
            synchronized (stack) {
                this.v2.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.v2;
            synchronized (stack) {
                return Stack.sync((Stack)this.v2.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.v2;
            synchronized (stack) {
                return this.v2.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(v8 array, int index) {
            Stack stack = this.v2;
            synchronized (stack) {
                this.v2.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.v2;
            synchronized (stack) {
                return new Enumerator(this.v2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.v2;
            synchronized (stack) {
                return this.v2.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.v2;
            synchronized (stack) {
                return this.v2.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.v2;
            synchronized (stack) {
                this.v2.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.v2;
            synchronized (stack) {
                return this.v2.toArray(a);
            }
        }
    }
}

