/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.nr.ni;
import com.aspose.slides.internal.nr.r3;
import com.aspose.slides.internal.qe.aa;
import com.aspose.slides.internal.qe.pf;
import com.aspose.slides.internal.xs.de;
import com.aspose.slides.internal.xs.iz;
import com.aspose.slides.internal.xs.kn;
import com.aspose.slides.internal.xs.pm;
import com.aspose.slides.internal.xs.zu;
import com.aspose.slides.internal.z3.aw;
import com.aspose.slides.ms.System.gd;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.rg;
import com.aspose.slides.ms.System.wo;
import com.aspose.slides.ms.System.yl;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@yl
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
iz,
kn,
gd,
Map {
    private IGenericEqualityComparer pf;
    private final Object aa = new Object();
    private Bucket[] r3;
    private int ik;
    private volatile boolean pd;
    private ICollection ni;
    private float iz;
    private int nq;
    private zu aw;
    private int kn;
    private ICollection es;
    private volatile int vt;
    private static final ni qf = new ni("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", wo.pf("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.iz = 0.72f * loadFactor;
        double d = (float)capacity / this.iz;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.qe.pf.pf((int)d) : 11;
        this.r3 = this.aa(n);
        this.nq = (int)(this.iz * (float)n);
        this.pd = false;
    }

    protected Hashtable(zu info, de context) {
        this.aw = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.pf = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.pf = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key2, Object value) {
        this.pf(key2, value, true);
    }

    @Override
    public void clear() {
        if (this.ik != 0) {
            this.pd = true;
            for (int i = 0; i < this.r3.length; ++i) {
                this.r3[i].r3 = 0;
                this.r3[i].pf = null;
                this.r3[i].aa = null;
            }
            this.ik = 0;
            this.kn = 0;
            this.ik();
            this.pd = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.r3;
        Hashtable hashtable = new Hashtable(this.ik, this.pf);
        hashtable.vt = this.vt;
        hashtable.iz = this.iz;
        hashtable.ik = 0;
        int n = this.r3.length;
        while (n > 0) {
            Object object = bucketArray[--n].pf;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].aa);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key2) {
        return this.containsKey(key2);
    }

    @Override
    public boolean containsKey(Object key2) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key2 == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.r3;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.pf(key2, this.r3.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.r3.length);
        do {
            bucketArray[n10].pf(bucket);
            if (bucket.pf == null) {
                return false;
            }
            if ((long)(bucket.r3 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.pf, key2)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.r3.length);
        } while (bucket.r3 < 0 && ++n < this.r3.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.r3.length;
            while (--n >= 0) {
                if (this.r3[n].pf == null || this.r3[n].pf == this.r3 || this.r3[n].aa != null) continue;
                return true;
            }
        } else {
            int n = this.r3.length;
            while (--n >= 0) {
                Object object = this.r3[n].aa;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void r3(ik ik2, int n) {
        Bucket[] bucketArray = this.r3;
        int n10 = this.r3.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].pf;
            if (object == null || object == this.r3) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].aa);
            ik2.r3(dictionaryEntry.Clone(), n++);
        }
    }

    void pf(ik ik2, int n) {
        Bucket[] bucketArray = this.r3;
        int n10 = this.r3.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].pf;
            if (object == null || object == this.r3) continue;
            ik2.r3(object, n++);
        }
    }

    @Override
    public void copyTo(ik array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.ik() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.pd() - arrayIndex < this.ik) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.r3(array, arrayIndex);
    }

    void aa(ik ik2, int n) {
        Bucket[] bucketArray = this.r3;
        int n10 = this.r3.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].pf;
            if (object == null || object == this.r3) continue;
            ik2.r3(bucketArray[n10].aa, n++);
        }
    }

    private void aa() {
        int n = com.aspose.slides.internal.qe.pf.pf(this.r3.length * 2);
        this.pf(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key2) {
        if (this.pf != null) {
            return this.pf.hashCode(key2);
        }
        return key2.hashCode();
    }

    @Override
    public void getObjectData(zu info, de context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.pf("LoadFactor", this.iz);
        info.pf("Version", this.vt);
        if (this.pf == null) {
            info.pf("Comparer", null, com.aspose.slides.internal.nr.r3.pf(Comparator.class));
            info.pf("HashCodeProvider", null, com.aspose.slides.internal.nr.r3.pf(IHashCodeProvider.class));
        } else if (this.pf instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.nr.r3.pf(this.pf, CompatibleComparer.class);
            info.pf("Comparer", objectArray.pf(), com.aspose.slides.internal.nr.r3.pf(Comparator.class));
            info.pf("HashCodeProvider", objectArray.aa(), com.aspose.slides.internal.nr.r3.pf(IHashCodeProvider.class));
        } else {
            info.pf("KeyComparer", this.pf, com.aspose.slides.internal.nr.r3.pf(IGenericEqualityComparer.class));
        }
        info.pf("HashSize", this.r3.length);
        objectArray = new Object[this.ik];
        Object[] objectArray2 = new Object[this.ik];
        this.pf(com.aspose.slides.ms.System.ik.pf(objectArray), 0);
        this.aa(com.aspose.slides.ms.System.ik.pf(objectArray2), 0);
        info.pf("Keys", objectArray, com.aspose.slides.internal.nr.r3.pf(Object[].class));
        info.pf("Values", objectArray2, com.aspose.slides.internal.nr.r3.pf(Object[].class));
    }

    private long pf(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void pf(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.ik >= this.nq) {
                this.aa();
            } else if (this.kn > this.nq && this.ik > 100) {
                this.r3();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.pf(object, this.r3.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.r3.length);
            do {
                if (n10 == -1 && this.r3[n11].pf == this.r3 && this.r3[n11].r3 < 0) {
                    n10 = n11;
                }
                if (this.r3[n11].pf == null || this.r3[n11].pf == this.r3 && ((long)this.r3[n11].r3 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.pd = true;
                    this.r3[n11].aa = object2;
                    this.r3[n11].pf = object;
                    this.r3[n11].r3 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.ik;
                    this.ik();
                    this.pd = false;
                    break block12;
                }
                if ((long)(this.r3[n11].r3 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.r3[n11].pf, object)) {
                    if (bl2) {
                        throw new ArgumentException(wo.pf("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.r3[n11].pf, object));
                    }
                    this.pd = true;
                    this.r3[n11].aa = object2;
                    this.ik();
                    this.pd = false;
                    break block12;
                }
                if (n10 == -1 && this.r3[n11].r3 >= 0) {
                    this.r3[n11].r3 = (int)((long)this.r3[n11].r3 | Integer.MIN_VALUE);
                    ++this.kn;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.r3.length);
            } while (++n < this.r3.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.pd = true;
            this.r3[n10].aa = object2;
            this.r3[n10].pf = object;
            this.r3[n10].r3 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.ik;
            this.ik();
            this.pd = false;
        }
    }

    protected boolean keyEquals(Object item, Object key2) {
        if (rg.aa(this.r3, item)) {
            return false;
        }
        if (this.pf != null) {
            return this.pf.equals(item, key2);
        }
        return item != null && item.equals(key2);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.r3 == null) {
            if (this.aw == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            pm pm2 = this.aw.ik();
            while (pm2.hasNext()) {
                switch (qf.pf(pm2.aa())) {
                    case 0: {
                        this.iz = this.aw.aa("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.aw.pf("HashSize");
                        break;
                    }
                    case 2: {
                        this.pf = (IGenericEqualityComparer)this.aw.pf("KeyComparer", com.aspose.slides.internal.nr.r3.pf(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.aw.pf("Comparer", com.aspose.slides.internal.nr.r3.pf(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.aw.pf("HashCodeProvider", com.aspose.slides.internal.nr.r3.pf(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.aw.pf("Keys", com.aspose.slides.internal.nr.r3.pf(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.aw.pf("Values", com.aspose.slides.internal.nr.r3.pf(Object[].class));
                    }
                }
            }
            this.nq = (int)(this.iz * (float)n);
            if (this.pf == null && (comparator != null || iHashCodeProvider != null)) {
                this.pf = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.r3 = this.aa(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.pf(objectArray[i], objectArray2[i], true);
            }
            this.vt = this.aw.pf("Version");
            this.aw = null;
        }
    }

    private void pf(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = n;
        long l10 = 1L + (((l & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].pf == null || bucketArray[n10].pf == this.r3) {
                bucketArray[n10].aa = object2;
                bucketArray[n10].pf = object;
                bucketArray[n10].r3 |= n;
                break;
            }
            if (bucketArray[n10].r3 >= 0) {
                bucketArray[n10].r3 = (int)((long)bucketArray[n10].r3 | Integer.MIN_VALUE);
                ++this.kn;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void r3() {
        this.pf(this.r3.length);
    }

    private void pf(int n) {
        this.kn = 0;
        Bucket[] bucketArray = this.aa(n);
        for (int i = 0; i < this.r3.length; ++i) {
            Bucket bucket = this.r3[i].pf();
            if (bucket.pf == null || bucket.pf == this.r3) continue;
            this.pf(bucketArray, bucket.pf, bucket.aa, bucket.r3 & Integer.MAX_VALUE);
        }
        this.pd = true;
        this.r3 = bucketArray;
        this.nq = (int)(this.iz * (float)n);
        this.ik();
        this.pd = false;
    }

    @Override
    public void removeItem(Object key2) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key2 == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.pf(key2, this.r3.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.r3.length);
        do {
            this.r3[n10].pf(bucket);
            if ((long)(bucket.r3 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.pf, key2)) {
                this.pd = true;
                this.r3[n10].r3 = (int)((long)this.r3[n10].r3 & Integer.MIN_VALUE);
                this.r3[n10].pf = this.r3[n10].r3 != 0 ? this.r3 : null;
                this.r3[n10].aa = null;
                --this.ik;
                this.ik();
                this.pd = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.r3.length);
        } while (bucket.r3 < 0 && ++n < this.r3.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] pf() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.ik];
        int n = 0;
        Bucket[] bucketArray = this.r3;
        int n10 = this.r3.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].pf;
            if (object == null || object == this.r3) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].aa);
        }
        return keyValuePairsArray;
    }

    private void ik() {
        ++this.vt;
    }

    private Bucket[] aa(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.ik;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.pf;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key2) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key2 == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.r3;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.pf(key2, this.r3.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.r3.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.vt;
                bucketArray[n10].pf(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.z3.aw.aa(1);
            } while (this.pd || n11 != this.vt);
            if (bucket.pf == null) break;
            if ((long)(bucket.r3 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.pf, key2)) {
                return bucket.aa;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.r3.length);
        } while (bucket.r3 < 0 && ++n < this.r3.length);
        return null;
    }

    @Override
    public void set_Item(Object key2, Object value) {
        this.pf(key2, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.ni == null) {
            this.ni = new KeyCollection(this);
        }
        return this.ni;
    }

    @Override
    public Object getSyncRoot() {
        return this.aa;
    }

    @Override
    public ICollection getValues() {
        if (this.es == null) {
            this.es = new ValueCollection(this);
        }
        return this.es;
    }

    @Override
    public boolean isEmpty() {
        return this.ik == 0;
    }

    public Object get(Object key2) {
        return this.get_Item(key2);
    }

    public Object put(Object key2, Object value) {
        Object object = this.get_Item(key2);
        this.set_Item(key2, value);
        return object;
    }

    public Object remove(Object key2) {
        Object object = this.get_Item(key2);
        this.removeItem(key2);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        ik ik2 = com.aspose.slides.ms.System.ik.pf(objectArray);
        this.getKeys().copyTo(ik2, 0);
        return new ReadOnlyItemCollection(ik2);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        ik ik2 = com.aspose.slides.ms.System.ik.pf(objectArray);
        this.getValues().copyTo(ik2, 0);
        return new ReadOnlyItemCollection(ik2);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.pf();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].pf(), keyValuePairsArray[i].aa());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.ik.pf(entryArray));
    }

    public int getVersion() {
        return this.vt;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new aa(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private ik aa;

        ReadOnlyItemCollection(ik items) {
            this.aa = items;
        }

        @Override
        public int size() {
            return this.aa.size();
        }

        @Override
        public boolean isEmpty() {
            return this.aa.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.aa.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.aa.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            ik ik2 = com.aspose.slides.ms.System.ik.pf(objectArray);
            this.aa.copyTo(ik2, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.aa.copyTo(com.aspose.slides.ms.System.ik.pf(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @yl
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable pf;

        SyncHashtable(Hashtable table) {
            super(false);
            this.pf = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key2, Object value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.addItem(key2, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.pf.deepClone());
            }
        }

        @Override
        public boolean contains(Object key2) {
            return this.pf.contains(key2);
        }

        @Override
        public boolean containsKey(Object key2) {
            return this.pf.containsKey(key2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.containsValue(key2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array, int arrayIndex) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.pf.iterator();
        }

        @Override
        public void getObjectData(zu info, de context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.pf("ParentTable", this.pf, com.aspose.slides.internal.nr.r3.pf(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.removeItem(key2);
            }
        }

        @Override
        KeyValuePairs[] pf() {
            return this.pf.pf();
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.pf.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.pf.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key2) {
            return this.pf.get_Item(key2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key2, Object value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.set_Item(key2, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.getValues();
            }
        }
    }

    @yl
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable pf;

        ValueCollection(Hashtable hashtable) {
            this.pf = hashtable;
        }

        @Override
        public void copyTo(ik array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ik() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.pd() - arrayIndex < this.pf.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.pf.aa(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.pf, 2);
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }
    }

    @yl
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable pf;

        KeyCollection(Hashtable hashtable) {
            this.pf = hashtable;
        }

        @Override
        public void copyTo(ik array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.ik() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.pd() - arrayIndex < this.pf.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.pf.pf(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.pf, 1);
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }
    }

    @yl
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int pf;
        private boolean aa;
        private Object r3;
        private Object ik;
        private int pd;
        private Hashtable ni;
        private int iz;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.ni = hashtable;
            this.pf = hashtable.r3.length;
            this.iz = hashtable.vt;
            this.aa = false;
            this.pd = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.iz != this.ni.vt) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.pf > 0) {
                --this.pf;
                Object object = ((Hashtable)this.ni).r3[this.pf].pf;
                if (object == null || object == this.ni.r3) continue;
                this.r3 = object;
                this.ik = ((Hashtable)this.ni).r3[this.pf].aa;
                this.aa = true;
                return true;
            }
            this.aa = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.iz != this.ni.vt) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.aa = false;
            this.pf = this.ni.r3.length;
            this.r3 = null;
            this.ik = null;
        }

        @Override
        public Object next() {
            if (!this.aa) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.pd == 1) {
                return this.r3;
            }
            if (this.pd == 2) {
                return this.ik;
            }
            return new DictionaryEntry(this.r3, this.ik);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.aa) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.r3, this.ik);
        }

        @Override
        public Object getKey() {
            if (!this.aa) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.r3;
        }

        @Override
        public Object getValue() {
            if (!this.aa) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.ik;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object pf;
        private Object aa;

        public KeyValuePairs(Object key2, Object value) {
            this.aa = value;
            this.pf = key2;
        }

        public Object pf() {
            return this.pf;
        }

        public Object aa() {
            return this.aa;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.nr.iz<Bucket> {
        public Object pf;
        public Object aa;
        public int r3;

        public void pf(Bucket bucket) {
            bucket.pf = this.pf;
            bucket.aa = this.aa;
            bucket.r3 = this.r3;
        }

        public Bucket pf() {
            Bucket bucket = new Bucket();
            this.pf(bucket);
            return bucket;
        }

        public Object clone() {
            return this.pf();
        }

        private boolean aa(Bucket bucket) {
            return rg.pf(bucket.pf, this.pf) && rg.pf(bucket.aa, this.aa) && bucket.r3 == this.r3;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (rg.aa(null, obj)) {
                return false;
            }
            if (rg.aa(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.aa((Bucket)obj);
        }

        public int hashCode() {
            int n = this.pf != null ? this.pf.hashCode() : 0;
            n = 31 * n + (this.aa != null ? this.aa.hashCode() : 0);
            n = 31 * n + this.r3;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.pf();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.pf((Bucket)object);
        }
    }

    @yl
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator pf;
        private IHashCodeProvider aa;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.pf = comparer;
            this.aa = hashCodeProvider;
        }

        public int pf(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.pf != null) {
                return this.pf.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.nr.r3.pf(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.pf(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.aa != null) {
                return this.aa.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator pf() {
            return this.pf;
        }

        IHashCodeProvider aa() {
            return this.aa;
        }
    }
}

