/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.gd;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.yl;
import java.util.Arrays;

@yl
public class Queue
implements ICollection,
IEnumerable,
gd {
    private Object[] pf;
    private int aa = 0;
    private int r3 = 0;
    private int ik = 0;
    private int pd;
    private int ni = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.pf = new Object[capacity];
        this.pd = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.r3;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(ik array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.ik() > 1 || index != 0 && index >= array.pd() || this.r3 > array.pd() - index) {
            throw new ArgumentException();
        }
        int n = this.pf.length;
        int n10 = n - this.aa;
        com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf), this.aa, array, index, Math.min(this.r3, n10));
        if (this.r3 > n10) {
            com.aspose.slides.ms.System.ik.pf(com.aspose.slides.ms.System.ik.pf(this.pf), 0, array, index + n10, this.r3 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.pf.length);
        queue.pd = this.pd;
        com.aspose.slides.ms.System.ik.pf(this.pf, 0, queue.pf, 0, this.pf.length);
        queue.aa = this.aa;
        queue.r3 = this.r3;
        queue.ik = this.ik;
        return queue;
    }

    public void clear() {
        ++this.ni;
        this.aa = 0;
        this.r3 = 0;
        this.ik = 0;
        for (int i = this.pf.length - 1; i >= 0; --i) {
            this.pf[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.aa + this.r3;
        if (obj == null) {
            for (int i = this.aa; i < n; ++i) {
                if (this.pf[i % this.pf.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.aa; i < n; ++i) {
                if (!obj.equals(this.pf[i % this.pf.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.ni;
        if (this.r3 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.pf[this.aa];
        this.pf[this.aa] = null;
        this.aa = (this.aa + 1) % this.pf.length;
        --this.r3;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.ni;
        if (this.r3 == this.pf.length) {
            this.pf();
        }
        this.pf[this.ik] = obj;
        this.ik = (this.ik + 1) % this.pf.length;
        ++this.r3;
    }

    public Object peek() {
        if (this.r3 < 1) {
            throw new InvalidOperationException();
        }
        return this.pf[this.aa];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.r3) {
            return Arrays.copyOf(this.pf, this.r3, a.getClass());
        }
        System.arraycopy(this.pf, 0, a, 0, this.r3);
        if (a.length > this.r3) {
            a[this.r3] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.ni;
        Object[] objectArray = new Object[this.r3];
        this.copyTo(com.aspose.slides.ms.System.ik.pf(objectArray), 0);
        this.pf = objectArray;
        this.aa = 0;
        this.ik = 0;
    }

    private void pf() {
        int n = this.pf.length * this.pd / 100;
        if (n < this.pf.length + 1) {
            n = this.pf.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.ik.pf(objectArray), 0);
        this.pf = objectArray;
        this.aa = 0;
        this.ik = this.aa + this.r3;
    }

    @yl
    private static class QueueEnumerator
    implements IEnumerator,
    gd {
        private Queue pf;
        private int aa;
        private int r3;

        QueueEnumerator(Queue q) {
            this.pf = q;
            this.aa = q.ni;
            this.r3 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.pf);
            queueEnumerator.aa = this.aa;
            queueEnumerator.r3 = this.r3;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.aa != this.pf.ni || this.r3 < 0 || this.r3 >= this.pf.r3) {
                throw new InvalidOperationException();
            }
            return this.pf.pf[(this.pf.aa + this.r3) % this.pf.pf.length];
        }

        @Override
        public boolean hasNext() {
            if (this.aa != this.pf.ni) {
                throw new InvalidOperationException();
            }
            if (this.r3 >= this.pf.r3 - 1) {
                this.r3 = Integer.MAX_VALUE;
                return false;
            }
            ++this.r3;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.aa != this.pf.ni) {
                throw new InvalidOperationException();
            }
            this.r3 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue pf;

        SyncQueue(Queue queue) {
            this.pf = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.pf;
            synchronized (queue) {
                return this.pf.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array, int index) {
            Queue queue = this.pf;
            synchronized (queue) {
                this.pf.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.pf;
            synchronized (queue) {
                return this.pf.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.pf;
            synchronized (queue) {
                return new SyncQueue((Queue)this.pf.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.pf;
            synchronized (queue) {
                this.pf.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.pf;
            synchronized (queue) {
                this.pf.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.pf;
            synchronized (queue) {
                return this.pf.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.pf;
            synchronized (queue) {
                return this.pf.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.pf;
            synchronized (queue) {
                this.pf.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.pf;
            synchronized (queue) {
                return this.pf.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.pf;
            synchronized (queue) {
                return this.pf.toArray(a);
            }
        }
    }
}

