/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.nr.iz;
import com.aspose.slides.ms.System.co;
import com.aspose.slides.ms.System.gd;
import com.aspose.slides.ms.System.ik;
import com.aspose.slides.ms.System.rg;
import com.aspose.slides.ms.System.wo;
import com.aspose.slides.ms.System.yl;
import java.util.Comparator;

@yl
public class SortedList
implements IDictionary,
gd {
    private final Object pf = new Object();
    private Slot[] aa;
    private Comparator r3;
    private int ik;
    private int pd;
    private int ni;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.ni = capacity == 0 ? 0 : 16;
        this.r3 = comparer;
        this.aa(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.r3 = comparer;
        this.aa(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.aa(d.size(), true);
        this.r3 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.ik;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.pf;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key2) {
        if (key2 == null) {
            throw new ArgumentNullException();
        }
        return this.pf(key2);
    }

    @Override
    public void set_Item(Object key2, Object value) {
        if (key2 == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.aa(key2) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.pf(key2, value, true);
    }

    public int getCapacity() {
        return this.aa.length;
    }

    public void setCapacity(int value) {
        int n = this.aa.length;
        if (this.ik > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.pf(this.ni);
            SortedList.pf(this.aa, 0, slotArray, 0, this.ik);
            this.aa = slotArray;
        } else if (value > this.ik) {
            Slot[] slotArray = SortedList.pf(value);
            SortedList.pf(this.aa, 0, slotArray, 0, this.ik);
            this.aa = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.pf(value);
            SortedList.pf(this.aa, 0, slotArray, 0, n);
            this.aa = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key2, Object value) {
        this.pf(key2, value, false);
    }

    @Override
    public void clear() {
        this.ni = 16;
        this.aa = SortedList.pf(this.ni);
        this.ik = 0;
        ++this.pd;
    }

    @Override
    public boolean contains(Object key2) {
        if (null == key2) {
            throw new ArgumentNullException();
        }
        try {
            return this.aa(key2) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key2) {
        int n = this.indexOfKey(key2);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(ik array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.ik() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.pd()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.pd() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.r3(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.r3);
        sortedList.pd = this.pd;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.aa;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.pf(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].pf = null;
                slotArray[index].aa = null;
            }
            --this.ik;
            ++this.pd;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key2) {
        if (null == key2) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.aa(key2);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.ik == 0) {
            return -1;
        }
        for (int i = 0; i < this.ik; ++i) {
            Slot slot = this.aa[i].Clone();
            if (!rg.pf(value, slot.aa)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key2) {
        if (null == key2) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key2);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.aa[index].aa;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.aa[index].aa = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.aa[index].pf;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.pf(this.ni, false);
        } else {
            this.pf(this.size(), true);
        }
    }

    private void pf(int n, boolean bl2) {
        Slot[] slotArray = this.aa;
        Slot[] slotArray2 = SortedList.pf(n);
        if (bl2) {
            SortedList.pf(slotArray, 0, slotArray2, 0, n);
        }
        this.aa = slotArray2;
    }

    private void pf(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.aa;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.pf(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.pf(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.pf(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.pf(slotArray, 0, slotArray2, 0, this.size());
            }
            this.aa = slotArray2;
        } else if (bl2) {
            SortedList.pf(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void pf(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.aa;
        int n = -1;
        try {
            n = this.aa(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = wo.pf("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].aa = object2;
            ++this.pd;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(wo.pf(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.pf(this.size() + 1, n);
        slotArray = this.aa;
        slotArray[n].pf = object;
        slotArray[n].aa = object2;
        ++this.ik;
        ++this.pd;
    }

    private Object pf(Object object) {
        int n = this.aa(object);
        if (n >= 0) {
            return this.aa[n].aa;
        }
        return null;
    }

    private void aa(int n, boolean bl2) {
        if (!bl2 && n < this.ni) {
            n = this.ni;
        }
        this.aa = SortedList.pf(n);
        this.ik = 0;
        this.pd = 0;
    }

    private void pf(ik ik2, int n, int n10) {
        if (ik2 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > ik2.pd()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            ik2.r3(enumerator.next(), n++);
        }
    }

    private int aa(Object object) {
        Slot[] slotArray = this.aa;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.r3 == null ? Comparer.Default : this.r3;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].pf, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] pf(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean pf(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void pf(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.pf(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList pf;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.pf = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.pf.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.pf.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                iCollection = this.pf.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                iCollection = this.pf.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.pf(key2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key2, Object value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.pf(key2, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(ik array, int arrayIndex) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key2, Object value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.pf(key2, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.aa(key2) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.removeItem(key2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.contains(key2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.pf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.pf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key2) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.indexOfKey(key2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                return this.pf.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.pf.getSyncRoot();
            synchronized (object) {
                this.pf.trimToSize();
            }
        }
    }

    @yl
    private static class ListValues
    implements IList {
        private SortedList pf;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.pf = host;
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        @Override
        public void copyTo(ik array, int arrayIndex) {
            this.pf.pf(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.pf.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.pf.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.pf, 1);
        }
    }

    @yl
    private static class ListKeys
    implements IList {
        private SortedList pf;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.pf = host;
        }

        @Override
        public int size() {
            return this.pf.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.pf.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.pf.getSyncRoot();
        }

        @Override
        public void copyTo(ik array, int arrayIndex) {
            this.pf.pf(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.pf.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key2) {
            return this.pf.contains(key2);
        }

        @Override
        public int indexOf(Object key2) {
            return this.pf.indexOfKey(key2);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.pf, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    gd {
        private SortedList pf;
        private Object aa;
        private Object r3;
        private int ik;
        private int pd;
        private int ni;
        private int iz;
        private boolean nq = false;
        private static String aw = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.pf = host;
            this.ik = host.pd;
            this.ni = host.size();
            this.iz = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.pf.pd != this.ik || this.nq) {
                throw new IllegalStateException(aw);
            }
            this.pd = -1;
            this.aa = null;
            this.r3 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.pf.pd != this.ik || this.nq) {
                throw new InvalidOperationException(aw);
            }
            return ++this.pd < this.ni;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            return new DictionaryEntry(this.aa, this.r3);
        }

        @Override
        public Object getKey() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            return this.aa;
        }

        @Override
        public Object getValue() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            return this.r3;
        }

        @Override
        public Object next() {
            if (this.pf.pd != this.ik || this.nq) {
                throw new InvalidOperationException(aw);
            }
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                if (this.pd >= this.ni) {
                    this.aa = null;
                    this.r3 = null;
                }
                throw new IllegalStateException(aw);
            }
            Slot[] slotArray = this.pf.aa;
            Slot slot = slotArray[this.pd].Clone();
            this.aa = slot.pf;
            this.r3 = slot.aa;
            switch (this.iz) {
                case 0: {
                    return this.aa;
                }
                case 1: {
                    return this.r3;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(wo.pf(new String[]{co.getName(EnumeratorMode.class, this.iz), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.pf, this.iz);
            enumeratorJava.ik = this.ik;
            enumeratorJava.pd = this.pd;
            enumeratorJava.ni = this.ni;
            enumeratorJava.aa = this.aa;
            enumeratorJava.r3 = this.r3;
            enumeratorJava.nq = this.nq;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    gd {
        private SortedList pf;
        private Object aa;
        private Object r3;
        private int ik;
        private int pd;
        private int ni;
        private int iz;
        private boolean nq = false;
        private static String aw = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.pf = host;
            this.ik = host.pd;
            this.ni = host.size();
            this.iz = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.pf.pd != this.ik || this.nq) {
                throw new IllegalStateException(aw);
            }
            this.pd = -1;
            this.aa = null;
            this.r3 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.pf.pd != this.ik || this.nq) {
                throw new InvalidOperationException(aw);
            }
            Slot[] slotArray = this.pf.aa;
            if (++this.pd < this.ni) {
                Slot slot = slotArray[this.pd].Clone();
                this.aa = slot.pf;
                this.r3 = slot.aa;
                return true;
            }
            this.aa = null;
            this.r3 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            return new DictionaryEntry(this.aa, this.r3);
        }

        @Override
        public Object getKey() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            return this.aa;
        }

        @Override
        public Object getValue() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            return this.r3;
        }

        @Override
        public Object next() {
            if (this.nq || this.pd >= this.ni || this.pd == -1) {
                throw new IllegalStateException(aw);
            }
            switch (this.iz) {
                case 0: {
                    return this.aa;
                }
                case 1: {
                    return this.r3;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(wo.pf(new String[]{co.getName(EnumeratorMode.class, this.iz), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.pf, this.iz);
            enumerator.ik = this.ik;
            enumerator.pd = this.pd;
            enumerator.ni = this.ni;
            enumerator.aa = this.aa;
            enumerator.r3 = this.r3;
            enumerator.nq = this.nq;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends co {
        private EnumeratorMode() {
        }

        static {
            co.register(new co.pd(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @yl
    public static class Slot
    extends iz<Slot> {
        Object pf;
        Object aa;

        @Override
        public void CloneTo(Slot that) {
            that.pf = this.pf;
            that.aa = this.aa;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean pf(Slot slot) {
            return rg.pf(slot.pf, this.pf) && rg.pf(slot.aa, this.aa);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (rg.aa(null, obj)) {
                return false;
            }
            if (rg.aa(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.pf((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.pf != null ? this.pf.hashCode() : 0;
            n = 31 * n + (this.aa != null ? this.aa.hashCode() : 0);
            return n;
        }
    }
}

