/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.b9.ow;
import com.aspose.slides.internal.nr.iz;
import com.aspose.slides.internal.nr.r3;
import com.aspose.slides.ms.System.gf;
import com.aspose.slides.ms.System.hl;

public class BitVector32
extends iz<BitVector32> {
    private int pf;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.pf = value.pf;
    }

    public BitVector32(int data) {
        this.pf = data;
    }

    public int getData() {
        return this.pf;
    }

    public int get_Item(Section section) {
        return this.pf >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.pf &= ~(section.getMask() << section.getOffset());
        this.pf |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.pf & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.pf = value ? (this.pf |= bit) : (this.pf &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.pf(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.pf(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(r3.aa((Object)n10, 9), r3.aa((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return r3.aa(o, BitVector32.class) && this.pf == r3.ik((Object)o, BitVector32.class).pf;
    }

    public int hashCode() {
        return hl.pf(this.pf);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        ow ow2 = new ow();
        ow2.pf("BitVector32{");
        for (long i = r3.ni((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            ow2.pf(((long)value.pf & i) == 0L ? (char)'0' : '1');
        }
        ow2.pf('}');
        return ow2.toString();
    }

    private static int pf(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.pf = this.pf;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends iz<Section> {
        private short pf;
        private short aa;

        public Section() {
        }

        Section(short mask, short offset) {
            this.pf = mask;
            this.aa = offset;
        }

        public short getMask() {
            return this.pf;
        }

        public short getOffset() {
            return this.aa;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.pf == b.pf && a.aa == b.aa;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.pf != b.pf || a.aa != b.aa;
        }

        public boolean equals(Section obj) {
            return this.pf == obj.pf && this.aa == obj.aa;
        }

        public boolean equals(Object o) {
            if (!r3.aa(o, Section.class)) {
                return false;
            }
            Section section = r3.ik(o, Section.class).Clone();
            return this.pf == section.pf && this.aa == section.aa;
        }

        public int hashCode() {
            return this.pf << this.aa;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            ow ow2 = new ow();
            ow2.pf("Section{0x");
            ow2.pf(gf.pf(value.getMask(), 16));
            ow2.pf(", 0x");
            ow2.pf(gf.pf(value.getOffset(), 16));
            ow2.pf("}");
            return ow2.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.pf = this.pf;
            that.aa = this.aa;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

