/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.internal.zzY3x;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXPc;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzXPc zzYtv;

    BorderCollection(zzXPc parent) {
        this.zzYtv = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzQ9.zzak(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzX06().equals(brColl.zzX06()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzYtv.getPossibleBorderKeys().zzXSC(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzYtv.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzYtv, borderKey);
            this.zzYtv.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzYtv.getPossibleBorderKeys().zzZJx().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzYtv.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzYtv.getPossibleBorderKeys().zzZJx().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXev(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzYtv.getPossibleBorderKeys().zzZJx().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXev(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzX06().zzYbK();
    }

    public final void setColor(Color value) throws Exception {
        this.zzZL0(zzY3x.zzMp(value));
    }

    private zzY3x zzX06() throws Exception {
        return this.get(0).zzX06();
    }

    private void zzZL0(zzY3x zzY3x2) throws Exception {
        Iterator iterator = this.zzYtv.getPossibleBorderKeys().zzZJx().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXev(n)) continue;
            this.getByBorderType(n).zzZL0(zzY3x2);
        }
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzYtv.getPossibleBorderKeys().zzZJx().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXev(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzYtv.getPossibleBorderKeys().zzZJx().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzXev(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzXSC(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzXev(int n) {
        return n != 6 && n != 7;
    }

    static final class zzXSC
    implements Iterator<Border> {
        private BorderCollection zzYmn;
        private int zzYxv;

        zzXSC(BorderCollection borderCollection) {
            this.zzYmn = borderCollection;
            this.zzYxv = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzYxv >= this.zzYmn.getCount() - 1) {
                return false;
            }
            ++this.zzYxv;
            return true;
        }

        private Border zzWfG() {
            try {
                return this.zzYmn.get(this.zzYxv);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzWfG();
        }
    }
}

