/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzLJ;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.zz7F;
import com.aspose.words.zzW33;
import com.aspose.words.zzXBN;
import com.aspose.words.zzXUw;
import com.aspose.words.zzXd;
import com.aspose.words.zzXpM;
import com.aspose.words.zzY3W;
import com.aspose.words.zzYpj;
import com.aspose.words.zzZi0;
import com.aspose.words.zznr;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzXpM zzYWo;

    ChartSeriesCollection(zzXpM dmlChart) {
        this.zzYWo = dmlChart;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYWo.zzWKJ().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYWo.zzWKJ().iterator();
    }

    public void removeAt(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzYWo.zzWKJ().remove(index);
    }

    public void clear() {
        ChartSeriesCollection chartSeriesCollection = this;
        chartSeriesCollection.zzYWo.zzWKJ().clear();
        this.zzAz(false);
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        if (categories == null || values == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (categories.length <= 0 || values.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (categories.length != values.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXSC(seriesName, values);
        chartSeries.zzYwh().zzXSC(ChartSeriesCollection.zzaF(categories));
        return chartSeries;
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXSC(seriesName, yValues);
        chartSeries.zzYwh().zzXSC(ChartSeriesCollection.zzVV9(xValues));
        return chartSeries;
    }

    private ChartSeries zzXSC(String string, zzLJ[] zzLJArray, double[] dArray) {
        if (zzLJArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzLJArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzLJArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzXSC(string, dArray);
        chartSeries.zzYwh().zzXSC(ChartSeriesCollection.zzXSC(zzLJArray));
        if (!this.zzYWo.zzWWc()) {
            this.zzAz(true);
        }
        return chartSeries;
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzXSC(seriesName, zzLJ.zzXSC(dates), values);
    }

    private void zzAz(boolean bl) {
        zzW33 zzW332 = zzQ9.zzXSC((Object)this.zzYWo, zzW33.class);
        if (zzW332 != null && zzW332.zzIR().zzY9q()) {
            zzW332.zzIR().zzYA8().zzXRC(2, bl);
        }
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        if (xValues == null || yValues == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (xValues.length <= 0 || yValues.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (xValues.length != yValues.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (this.zzYWo.zzx() != 15) {
            this.zzYWo.zz6A(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzXSC(seriesName, yValues);
        chartSeries.zzWXi().zzX1i().zzXRC(3, this.zzYWo.zzX1D());
        chartSeries.zzYwh().zzXSC(ChartSeriesCollection.zzVV9(xValues));
        if (bubbleSizes != null) {
            chartSeries.zzWkg().zzXSC(ChartSeriesCollection.zzVV9(bubbleSizes));
        }
        return chartSeries;
    }

    private ChartSeries zzXSC(String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(this.zzYWo);
        chartSeries.setName(string);
        this.zzGr(chartSeries);
        chartSeries.zzWYo(this.zzYWo.zzWKJ().size());
        ChartSeries chartSeries2 = chartSeries;
        chartSeries2.zzYin(chartSeries2.getIndex());
        chartSeries.zzVXV().zzXSC(ChartSeriesCollection.zzVV9(dArray));
        chartSeries.zzWhK().zzXSC(chartSeries.zzVXV().zzY96());
        this.zzYWo.zzW3w(chartSeries);
        return chartSeries;
    }

    private void zzGr(ChartSeries chartSeries) {
        chartSeries.zzWXi().zzX1i().zzXRC(5, new zzY3W());
        switch (this.zzYWo.zzx()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzXSC(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzXSC(chartSeries, 5);
                ChartSeriesCollection.zzWmO(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzXSC(chartSeries, 1);
                ChartSeriesCollection.zzWmO(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zz6A(chartSeries);
            }
        }
    }

    private static void zz6A(ChartSeries chartSeries) {
        zzY3W zzY3W2 = new zzY3W();
        zzY3W2.zzY5s(new zzXUw());
        zz7F zz7F2 = new zz7F();
        zz7F2.zz5G(1);
        zzY3W2.zzW1y().zzY5s(new zznr(zz7F2));
        zzY3W2.zzW1y().zzZzc(19050.0);
        chartSeries.zzWXi().zzX1i().zzXRC(5, zzY3W2);
    }

    private static void zzWmO(ChartSeries chartSeries) {
        zzY3W zzY3W2 = new zzY3W();
        zzY3W2.zzY5s(new zzXUw());
        zzY3W2.zzW1y().zzY5s(new zzZi0());
        zzY3W2.zzW1y().setEndCap(0);
        zzY3W2.zzW1y().zzZzc(19050.0);
        chartSeries.zzWXi().zzX1i().zzXRC(5, zzY3W2);
    }

    private static void zzXSC(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker();
        chartMarker.zzXqU().zzXRC(0, n);
        chartSeries.zzWXi().zzX1i().zzXRC(4, chartMarker);
    }

    private static zzYpj zzVV9(double[] dArray) {
        int n = 0;
        zzYpj zzYpj2 = new zzYpj(2, false);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzYpj2.zzYze(new zzXBN(n, d, "General"));
            }
            ++n;
        }
        zzYpj2.zzXak(dArray.length);
        zzYpj2.zzXDJ();
        return zzYpj2;
    }

    private static zzYpj zzXSC(zzLJ[] zzLJArray) {
        int n = 0;
        zzYpj zzYpj2 = new zzYpj(2, false);
        zzLJ[] zzLJArray2 = zzLJArray;
        int n2 = zzLJArray.length;
        for (int i = 0; i < n2; ++i) {
            zzLJ zzLJ2 = zzLJArray2[i];
            zzYpj2.zzYze(new zzXBN(n++, zzLJ2.zzXew(), "m/d/yyyy"));
        }
        zzYpj2.zzXak(zzLJArray.length);
        zzYpj2.zzXDJ();
        return zzYpj2;
    }

    private static zzYpj zzaF(String[] stringArray) {
        int n = 0;
        zzYpj zzYpj2 = new zzYpj(1, false);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzYpj2.zzYze(new zzXd(n++, string));
        }
        zzYpj2.zzXak(stringArray.length);
        zzYpj2.zzXDJ();
        return zzYpj2;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzYWo.zzWKJ().size();
    }
}

