/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzVOD;
import com.aspose.words.zzW3I;
import com.aspose.words.zzXSR;
import com.aspose.words.zzXWk;
import com.aspose.words.zzYNg;
import com.aspose.words.zzf2;
import com.aspose.words.zzm5;
import java.util.Iterator;

public abstract class CompositeNode<T extends Node>
extends Node
implements zzVOD,
Iterable<T> {
    private Node zzYo4;
    private Node zzJj;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        while (this.hasChildNodes()) {
            this.getParentNode().insertAfter(this.getLastChild(), this);
        }
        this.remove();
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzWqP() {
        return this.zzWDp() != null;
    }

    final boolean zzvJ() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzWeM() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYNg) {
                return true;
            }
            CompositeNode compositeNode = zzQ9.zzXSC((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzWeM()) continue;
            return true;
        }
        return false;
    }

    public NodeCollection getChildNodes() {
        return this.getChildNodes(0, false);
    }

    public Node getFirstChild() {
        return this.zzYo4;
    }

    public Node getLastChild() {
        return this.zzJj;
    }

    final Node zzWDp() {
        return zzXWk.zzWmO(this.getFirstChild(), false);
    }

    final Node zzs2() {
        return zzXWk.zzW3w(this.getLastChild(), false);
    }

    final CompositeNode zzZ6M() {
        return (CompositeNode)zzXWk.zzWmO(this.getFirstChild(), true);
    }

    final CompositeNode zzXbR() {
        return (CompositeNode)zzXWk.zzW3w(this.getLastChild(), true);
    }

    final Node zzY1J() {
        Node node;
        for (node = this.getFirstChild(); node != null && zzXWk.zzZGy(node); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzVZq() {
        Node node;
        for (node = this.getLastChild(); node != null && zzXWk.zzZGy(node); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzXSC(boolean bl, zzf2 zzf22) {
        CompositeNode compositeNode = (CompositeNode)super.zzXSC(bl, zzf22);
        ((CompositeNode)super.zzXSC(bl, zzf22)).zzJj = null;
        compositeNode.zzYo4 = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzZ92(node.zzXSC(true, zzf22));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzZuz(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzZuz(StringBuilder stringBuilder) {
        this.zzXbj(stringBuilder);
        zzQ9.zzY5s(stringBuilder, this.zzWv9());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzY5s(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, true);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzXWk.zzWsn(nodeType);
            Node node2 = node = bl ? this.zzWDp() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzeK() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXSR.zzXl6(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXSR.zzVV9(this, xpath);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzW3I(this);
    }

    public Node appendChild(Node newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public Node prependChild(Node newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public Node insertAfter(Node newChild, Node refChild) {
        return this.zzXSC(newChild, refChild, true);
    }

    public Node insertBefore(Node newChild, Node refChild) {
        return this.zzXSC(newChild, refChild, false);
    }

    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new NullPointerException("oldChild");
        }
        if (oldChild.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = documentBase.zzXSC(oldChild, this, null, 1);
        if (documentBase.zz4a() && zzXWk.zzW5a(oldChild)) {
            return oldChild;
        }
        if (nodeChangingArgs != null) {
            documentBase.zzXSC(nodeChangingArgs);
        }
        Node node = this.zzYtA(oldChild);
        if (nodeChangingArgs != null) {
            documentBase.zzY5s(nodeChangingArgs);
        }
        return node;
    }

    public void removeAllChildren() {
        zzm5.zzZGy(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzZ92(Node node) {
        node.getParentNode();
        if (this.zzJj == null) {
            node.zzZHB(null);
            node.zzXRV(null);
            this.zzYo4 = node;
        } else {
            node.zzZHB(this.zzJj);
            node.zzXRV(null);
            this.zzJj.zzXRV(node);
        }
        this.zzJj = node;
        node.zzZmY(this);
        return node;
    }

    final void zzXSC(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            this.insertBefore(node4, node3);
            node4 = node5;
        }
    }

    final void zzY5s(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzY5s(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (zzXWk.zzZGy(node2)) continue;
            if (zzXWk.zzMp(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzWv9().length();
    }

    String zzWv9() {
        return "";
    }

    final String zzWNw() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXbj(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzXbj(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzZuz(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.zzXSC(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.zzY5s(visitor));
    }

    abstract int zzXSC(DocumentVisitor var1) throws Exception;

    abstract int zzY5s(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    abstract boolean zzXbj(Node var1);

    final Node zzXSC(Node node, Node node2, boolean bl) {
        NodeChangingArgs nodeChangingArgs;
        if (node2 != null && node2.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (node == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzY1z(node)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (node == node2) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = node.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (node.getNodeType() != 35 && !this.zzXbj(node)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        if (node.getParentNode() != null) {
            node.getParentNode().removeChild(node);
            if (!node.zzXXl()) {
                node.getParentNode().zzYtA(node);
            }
        }
        if ((nodeChangingArgs = documentBase.zzXSC(node, null, this, 0)) != null) {
            documentBase.zzXSC(nodeChangingArgs);
        }
        if (this.zzJj == null) {
            node.zzZHB(null);
            node.zzXRV(null);
            this.zzYo4 = node;
            this.zzJj = node;
        } else if (bl) {
            if (node2 != null) {
                this.zzY5s(node, node2);
            } else {
                this.zzXl6(node, this.zzYo4);
            }
        } else if (node2 != null) {
            this.zzXl6(node, node2);
        } else {
            this.zzY5s(node, this.zzJj);
        }
        node.zzZmY(this);
        if (nodeChangingArgs != null) {
            documentBase.zzY5s(nodeChangingArgs);
        }
        if (documentBase.zz4a()) {
            zzXWk.zzWho(node);
        }
        return node;
    }

    private void zzY5s(Node node, Node node2) {
        Node node3 = node2.zzWvw();
        node.zzZHB(node2);
        node.zzXRV(node3);
        node2.zzXRV(node);
        if (node3 == null) {
            this.zzJj = node;
            return;
        }
        node3.zzZHB(node);
    }

    private void zzXl6(Node node, Node node2) {
        Node node3 = node2.zzXBh();
        node.zzZHB(node3);
        node.zzXRV(node2);
        node2.zzZHB(node);
        if (node3 == null) {
            this.zzYo4 = node;
            return;
        }
        node3.zzXRV(node);
    }

    private Node zzYtA(Node node) {
        if (node == this.zzYo4) {
            if (this.zzYo4 == this.zzJj) {
                this.zzYo4 = null;
                this.zzJj = null;
            } else {
                this.zzYo4 = node.zzWvw();
                this.zzYo4.zzZHB(null);
            }
        } else {
            Node node2 = node.zzXBh();
            Node node3 = node.zzWvw();
            node2.zzXRV(node3);
            if (node3 == null) {
                this.zzJj = node2;
            } else {
                node3.zzZHB(node2);
            }
        }
        node.zzXRV(null);
        node.zzZHB(null);
        node.zzZmY(null);
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) {
        Node node = curNode.get();
        Ref<Node> ref = curNode;
        ref.set(ref.get() == this ? this.getFirstChild() : curNode.get().getNextSibling());
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

