/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzGW;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.internal.zzVRQ;
import com.aspose.words.internal.zzVXt;
import com.aspose.words.internal.zzWi6;
import com.aspose.words.internal.zzXBC;
import com.aspose.words.internal.zzXD1;
import com.aspose.words.internal.zzXfq;
import com.aspose.words.internal.zzYWm;
import com.aspose.words.internal.zzZ51;
import com.aspose.words.internal.zzZKK;
import com.aspose.words.internal.zzZd2;
import com.aspose.words.zzQF;
import com.aspose.words.zzUG;
import com.aspose.words.zzVSb;
import com.aspose.words.zzVWt;
import com.aspose.words.zzWKr;
import com.aspose.words.zzWiL;
import com.aspose.words.zzXQU;
import com.aspose.words.zzZPB;
import com.aspose.words.zzm7;
import com.aspose.words.zzrU;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzXSC(zzXD1 zzXD12, zzXD1 zzXD13, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzQ9.zzY5s((Object)zzXD12, "srcStream");
        zzQ9.zzY5s((Object)zzXD13, "dstStream");
        zzQ9.zzY5s((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzY5s(zzXD12, zzXD13, certificateHolder, signOptions);
        zzXD13.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzXSC(zzXD1.zzY5s(srcStream), (zzXD1)zzXD1.zzXl6(dstStream), certHolder, signOptions);
    }

    private static void zzY5s(zzXD1 zzXD12, zzXD1 zzXD13, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzXl6(digitalSignature);
        }
        if (zzm7.zzW1n(zzXD12)) {
            DigitalSignatureUtil.zzXSC(zzXD12, zzXD13, digitalSignature, true);
            return;
        }
        zzm7 zzm72 = new zzm7();
        zzXD1 zzXD14 = zzXD12;
        zzm7 zzm73 = zzm72;
        FileFormatInfo fileFormatInfo = zzm72.zzY5s(zzXD14, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZd2 zzZd22 = new zzZd2(zzXD12);
                int n = fileFormatInfo.zzZn6() == 1 ? 1 : 2;
                zzVWt.zzXSC(zzZd22, digitalSignature, n);
                zzXD13.zzPQ(0L);
                zzZd22.zzZyk(zzXD13);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzXSC(fileFormatInfo.zzZSn(), zzXD13, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzXSC(zzXD12, zzXD13, digitalSignature, false);
                return;
            }
            case 60: {
                DigitalSignatureUtil.zzXSC(zzXD12, zzXD13, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzQ9.zzXSC(srcFileName, "srcFileName");
        zzQ9.zzXSC(dstFileName, "dstFileName");
        zzZ51 zzZ512 = zzQ9.zzY5s(srcFileName, 3, 1);
        try {
            zzZ51 zzZ513 = zzQ9.zzY5s(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzXSC((zzXD1)zzZ512, (zzXD1)zzZ513, certHolder, signOptions);
            }
            finally {
                zzZ513.close();
            }
            return;
        }
        finally {
            zzZ512.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzYWm zzYWm2 = zzXD1.zzXl6(dstStream);
        zzXD1 zzXD12 = zzXD1.zzY5s(srcStream);
        DigitalSignatureUtil.zzXSC(zzXD12, (zzXD1)zzYWm2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zzZ51 zzZ512 = zzQ9.zzY5s(srcFileName, 3, 1);
        try {
            zzZ51 zzZ513 = zzQ9.zzY5s(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzMp(zzZ512, zzZ513);
            }
            finally {
                zzZ513.close();
            }
            return;
        }
        finally {
            zzZ512.close();
        }
    }

    private static void zzMp(zzXD1 zzXD12, zzXD1 zzXD13) throws Exception {
        zzm7 zzm72 = new zzm7();
        zzXD1 zzXD14 = zzXD12;
        zzm7 zzm73 = zzm72;
        FileFormatInfo fileFormatInfo = zzm72.zzY5s(zzXD14, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzZd2 zzZd22 = new zzZd2(zzXD12);
                zzZd22.zzWMV().zzKx("_xmlsignatures");
                zzZd22.zzWMV().zzKx("_signatures");
                zzXD13.zzW1j(0L);
                zzZd22.zzZyk(zzXD13);
                zzXD1 zzXD15 = zzXD13;
                zzXD15.zzPQ(zzXD15.zzbW());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzVRQ zzVRQ2 = new zzVRQ(zzXD12);
                zzGW zzGW2 = zzVRQ2.zzXSC(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzGW2 != null) {
                    for (zzXBC zzXBC2 : zzGW2.zzoV()) {
                        String string = zzGW2.zzXSC(zzXBC2);
                        zzVRQ2.zzN9().remove(string);
                    }
                    zzVRQ2.zzN9().remove(zzGW2.getName());
                    zzXBC zzXBC3 = zzVRQ2.zzoV().zzYW2("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzVRQ2.zzoV().remove(zzXBC3.getId());
                    zzVRQ2.zzX2F();
                }
                zzXD13.zzW1j(0L);
                zzVRQ2.zzZyk(zzXD13);
                zzXD1 zzXD16 = zzXD13;
                zzXD16.zzPQ(zzXD16.zzbW());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzMp(zzXD1.zzY5s(srcStream), zzXD1.zzXl6(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zzZ51 zzZ512 = zzQ9.zzY5s(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzW5a(zzZ512);
            return digitalSignatureCollection;
        }
        finally {
            zzZ512.close();
        }
    }

    private static DigitalSignatureCollection zzW5a(zzXD1 zzXD12) throws Exception {
        if (zzm7.zzW1n(zzXD12)) {
            return DigitalSignatureUtil.zzXe1(zzXD12);
        }
        zzm7 zzm72 = new zzm7();
        zzXD1 zzXD13 = zzXD12;
        zzm7 zzm73 = zzm72;
        FileFormatInfo fileFormatInfo = zzm72.zzY5s(zzXD13, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzXD12);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzW5a(zzXD1.zzY5s(stream));
    }

    static zzWi6 zzXSC(zzZd2 zzZd22, String string) throws Exception {
        zzWiL zzWiL2 = new zzWiL(zzZd22);
        if (zzWiL2.zzWRa()) {
            zzWi6 zzWi62 = zzWiL2.zzWO6(string);
            return zzWi62;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzXRl(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzXfq.zzY5s("Unexpected digest algorithm: {0}.", n));
    }

    static String zzZdT(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzXRl(n);
    }

    private static void zzXSC(zzXD1 zzXD12, zzXD1 zzXD13, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzVRQ zzVRQ2 = new zzVRQ(zzXD12);
        zzrU zzrU2 = bl ? new zzQF(zzVRQ2) : new zzWKr(zzVRQ2);
        zzrU2.zzY5s(digitalSignature);
        zzXD13.zzPQ(0L);
        zzVRQ2.zzZyk(zzXD13);
    }

    private static void zzXSC(zzXD1 zzXD12, zzXD1 zzXD13, DigitalSignature digitalSignature) throws Exception {
        zzZPB zzZPB2 = new zzZPB(zzXD12);
        zzXQU zzXQU2 = new zzXQU(zzZPB2);
        zzXQU2.zzY5s(digitalSignature);
        zzXD13.zzPQ(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXD1 zzXD14 = zzXD13;
        zzZPB zzZPB3 = zzZPB2;
        zzZPB3.zzXSC(zzXD14, string, null);
    }

    private static void zzXSC(zzZd2 zzZd22, zzXD1 zzXD12, DigitalSignature digitalSignature, String string) throws Exception {
        zzWi6 zzWi62 = DigitalSignatureUtil.zzXSC(zzZd22, string);
        zzWi6 zzWi63 = new zzWi6();
        DigitalSignatureUtil.zzXSC((zzXD1)zzWi62, (zzXD1)zzWi63, digitalSignature, false);
        zzZd2 zzZd23 = zzWiL.zzXl6(zzWi63, string);
        zzZd23.zzZyk(zzXD12);
    }

    private static DigitalSignatureCollection zzXe1(zzXD1 zzXD12) throws Exception {
        zzXD12.zzW1j(0L);
        zzVRQ zzVRQ2 = new zzVRQ(zzXD12);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzGW zzGW2 = zzVRQ2.zzXSC(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzGW2 != null) {
            for (zzXBC zzXBC2 : zzGW2.zzoV()) {
                String string = zzGW2.zzXSC(zzXBC2);
                zzGW zzGW3 = zzVRQ2.zzWC5(string);
                zzGW zzGW4 = zzVRQ2.zzXSC(zzGW3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzZKK zzZKK2 = zzVXt.zzXV8(zzGW4.zzZIO().zzY3a());
                zzUG.zzXSC(zzGW3.zzZ6d(), zzZKK2, new zzVSb(zzVRQ2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

