/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Table;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.internal.zzWAJ;
import com.aspose.words.internal.zzWi6;
import com.aspose.words.internal.zzWjG;
import com.aspose.words.internal.zzXD1;
import com.aspose.words.internal.zzXfq;
import com.aspose.words.internal.zzXpI;
import com.aspose.words.internal.zzYSb;
import com.aspose.words.internal.zzYrh;
import com.aspose.words.internal.zzZ15;
import com.aspose.words.internal.zzZdc;
import com.aspose.words.internal.zzZeg;
import com.aspose.words.internal.zzyX;
import com.aspose.words.zz4W;
import com.aspose.words.zz97;
import com.aspose.words.zzBE;
import com.aspose.words.zzDF;
import com.aspose.words.zzEk;
import com.aspose.words.zzVPc;
import com.aspose.words.zzVXX;
import com.aspose.words.zzVXi;
import com.aspose.words.zzWB3;
import com.aspose.words.zzWMi;
import com.aspose.words.zzWYB;
import com.aspose.words.zzWdp;
import com.aspose.words.zzWf3;
import com.aspose.words.zzX2c;
import com.aspose.words.zzXWk;
import com.aspose.words.zzXfn;
import com.aspose.words.zzXiL;
import com.aspose.words.zzY24;
import com.aspose.words.zzYC7;
import com.aspose.words.zzYI8;
import com.aspose.words.zzYLc;
import com.aspose.words.zzYY7;
import com.aspose.words.zzYdV;
import com.aspose.words.zzZ0K;
import com.aspose.words.zzZ0T;
import com.aspose.words.zzZ70;
import com.aspose.words.zzZB0;
import com.aspose.words.zzZK;
import com.aspose.words.zzZKv;
import com.aspose.words.zzZXz;
import com.aspose.words.zzZe0;
import com.aspose.words.zzZfN;
import com.aspose.words.zzZgj;
import com.aspose.words.zzac;
import com.aspose.words.zzld;
import com.aspose.words.zzu1;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzXiL,
zzYC7,
zzu1 {
    private Document zzX2;
    private Node zzWFt;
    private Node zzXdx;
    private zzZfN zzBk;
    private Font zzWpP;
    private zzZeg<zzZfN> zzZDv;
    private zzZ70 zzWDr = zzZ70.zzYlv();
    private zzWMi zzXP2 = new zzWMi();
    private RowFormat zzYeL;
    private CellFormat zzZNV;
    private zzZeg<zzYI8> zzY3U;
    private int zzYTi = 0;
    private int zzW0v = -1;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzZyk(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzZyk(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzZyk(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSC(documentBuilder.getCurrentSection(), zzZe0.zzZXh(headerFooterType), 0, 0);
    }

    private void zzZyk(int n, int n2, int n3, int n4) {
        this.zzX2.ensureMinimum();
        Section section = (Section)this.zzX2.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzXSC(section, 1, n3, n4);
    }

    private void zzXSC(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZe0.zzYyg(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = (HeaderFooter)section.appendChild(new HeaderFooter(this.zzX2, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzX2));
            }
        }
        this.zzXSC(story, n2, n3);
    }

    private void zzXSC(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        this.zzXl6(paragraph, n2);
    }

    final void zzXl6(Paragraph paragraph, int n) {
        if (n == 0) {
            Paragraph paragraph2 = paragraph;
            this.zzY5s(paragraph2, paragraph2.getFirstChild());
            return;
        }
        if (n == -1) {
            this.zzY5s(paragraph, null);
        }
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("fieldName");
        }
        FieldMergeField fieldMergeField = this.zzX8R().zzXXl() ? zzX2c.zzWmO(this.zzX2, fieldName) : zzX2c.zzW3w(this.zzX8R(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzXSC(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzXSC(field, isAfter, false);
    }

    private boolean zzXSC(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zz97 zz972 = field.getFormat().zzZe6();
        Inline inline = zz972.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzXSC(inline.zzXSK(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("bookmarkName");
        }
        Node node = isStart ? zzWYB.zzXSC(this.zzX2, bookmarkName) : zzWYB.zzY5s(this.zzX2, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzVTv() == 6) {
            this.zzY5s((Paragraph)node.zzZOc(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzXWk.zzyj(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzY5s(paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSC(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        if (characterIndex != 0 && characterIndex != -1) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: characterIndex");
        }
        Row row = this.zzYZT(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        if (characterIndex == 0) {
            this.zzXl6(cell.getFirstParagraph(), 0);
            return;
        }
        if (characterIndex == -1) {
            this.zzXl6(cell.getLastParagraph(), -1);
        }
    }

    private void zzY5s(Paragraph paragraph, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(paragraph);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzVTv() == 6) {
            this.zzZMW(node);
        } else if (zzXWk.zzZGy(node)) {
            Paragraph paragraph = zzXWk.zzyj(node);
            if (paragraph == null) {
                throw new IllegalStateException("There is no paragraph next to the specified node.");
            }
            this.zzZMW(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
        } else if (node.isComposite() && node.zzVTv() == 3) {
            Node node2 = ((CompositeNode)node).getChild(8, 0, true);
            if (node2 == null) {
                throw new IllegalStateException("The block level node doesn't contain paragraph.");
            }
            this.zzZMW(node2);
        } else {
            throw new IllegalStateException("The node must be a block or an inline.");
        }
        if (this.isAtEndOfParagraph()) {
            this.zzS3();
            return;
        }
        if (!this.zzYI()) {
            this.zzS3();
        }
    }

    private boolean zzYI() {
        Node node = this.zzX8R();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
        }
        if (node == null) {
            for (node = this.zzX8R(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzXSC(inline.zzXSK(), true);
            return true;
        }
        return false;
    }

    private void zzS3() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzXSC(documentBuilder.getCurrentParagraph().zzVVS(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYZT(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXGR() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzX8R().zzY1z(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzWHE();
                this.zzXl6(paragraph, 0);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzVPc(text, false);
    }

    public void writeln(String text) {
        this.zzVPc(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph = this.getCurrentParagraph();
        zzZXz zzZXz2 = new zzZXz(this.getDocument());
        try {
            Paragraph paragraph2 = new Paragraph(this.zzX2, this.zzXAS(), this.zzdb());
            this.getCurrentParagraph().getParentNode().insertAfter(paragraph2, this.getCurrentParagraph());
            if (this.isAtEndOfParagraph()) {
                this.moveTo(paragraph2);
            } else {
                paragraph2.zzY5s(this.zzX8R(), null, paragraph2.getLastChild());
            }
        }
        finally {
            zzZXz2.dispose();
        }
        if (this.getDocument().zz4a()) {
            zzXWk.zzXl6((zzVXX)paragraph, this.getDocument().zzZLT());
        }
        return this.getCurrentParagraph();
    }

    public void insertStyleSeparator() {
        zzEk.zzGr(this);
    }

    public void insertBreak(int breakType) {
        this.zzXjC(breakType, true);
    }

    final void zzXjC(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.insertParagraph();
                return;
            }
            case 1: {
                if (this.zzY3x(bl)) {
                    this.zzXd(ControlChar.PAGE_BREAK);
                }
                return;
            }
            case 2: {
                if (this.zzY3x(bl)) {
                    this.zzXd(ControlChar.COLUMN_BREAK);
                }
                return;
            }
            case 4: {
                if (this.zzY3x(bl)) {
                    this.zzZeD(1);
                }
                return;
            }
            case 5: {
                if (this.zzY3x(bl)) {
                    this.zzZeD(2);
                }
                return;
            }
            case 3: {
                if (this.zzY3x(bl)) {
                    this.zzZeD(0);
                }
                return;
            }
            case 6: {
                if (this.zzY3x(bl)) {
                    this.zzZeD(3);
                }
                return;
            }
            case 7: {
                if (this.zzY3x(bl)) {
                    this.zzZeD(4);
                }
                return;
            }
            case 8: {
                this.zzXd(ControlChar.LINE_BREAK);
                return;
            }
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzWAJ.zzZtk(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzXfq.zzY5s("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        return zzXWk.zzXSC(fieldType, updateField, this.zzdb(), this.zzX8R(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode) throws Exception {
        return zzXWk.zzXSC(fieldCode, this.zzdb(), this.zzX8R(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        return zzXWk.zzXSC(fieldCode, fieldValue, this.zzdb(), this.zzX8R(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzQ9.zzY5s((Object)displayText, "displayText");
        zzQ9.zzY5s((Object)urlOrBookmark, "hrefOrBookmark");
        zzYdV zzYdV2 = this.zzY5s(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzYdV2.zzY5s(documentBuilder.zzYGl(88, true));
        return zzXWk.zzXSC(zzYdV2.getStart(), zzYdV2.getSeparator(), zzYdV2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (format == null) {
            throw new NullPointerException("format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzZOv(70);
        if (zzWAJ.zzZtk(name)) {
            this.startBookmark(name);
        }
        this.zz9A(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZxs(70);
        String string = zzWAJ.zzZtk(fieldValue) ? fieldValue : FormField.zzWKI;
        Run run = new Run(this.zzX2, string, this.zzdb());
        this.insertNode(run);
        this.zzYGl(70, true);
        if (zzWAJ.zzZtk(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXzR(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzZOv(71);
        if (zzWAJ.zzZtk(name)) {
            this.startBookmark(name);
        }
        this.zz9A(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzYGl(71, false);
        if (zzWAJ.zzZtk(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXzR(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (items == null) {
            throw new NullPointerException("items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzZOv(83);
        if (zzWAJ.zzZtk(name)) {
            this.startBookmark(name);
        }
        this.zz9A(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzYGl(83, false);
        if (zzWAJ.zzZtk(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzXzR(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote((DocumentBase)this.zzX2, footnoteType);
        footnote.getFont().setStyleIdentifier(zzXWk.zzXTc(footnoteType));
        if (zzWAJ.zzZtk(referenceMark)) {
            footnote.setReferenceMark(referenceMark);
        }
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzX2);
        paragraph.getParagraphFormat().setStyleIdentifier(zzXWk.zzWuy(footnoteType));
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzX2, '\u0002', new zzZfN()) : new Run(this.zzX2, footnote.getReferenceMark(), new zzZfN());
        inline.getFont().setStyleIdentifier(zzXWk.zzXTc(footnoteType));
        paragraph.appendChild(inline);
        if (zzWAJ.zzZtk(footnoteText)) {
            Node node = this.zzX8R();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzZMW(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZj8(zzXD1 zzXD12) throws Exception {
        return this.zzXSC(zzXD12, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZj8(zzXD1.zzY5s(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzXSC(zzXD1 zzXD12, double d, double d2) throws Exception {
        return this.zzXSC(zzXD12, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzXSC(zzXD1.zzY5s(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("image");
        }
        zzWi6 zzWi62 = new zzWi6();
        try {
            zzZdc.zzXSC(image, zzWi62);
            Shape shape = this.zzXSC(zzWi62, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            zzWi62.close();
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzQ9.zzXSC(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzYrh.zzXEx(fileName);
        try {
            Shape shape = this.zzXSC((zzXD1)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzXD1)object).close();
            }
        }
    }

    private Shape zzXSC(zzXD1 zzXD12, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzXD12 == null) {
            throw new NullPointerException("stream");
        }
        byte[] byArray = zzQ9.zzGr(zzXD12);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzXSC(zzXD1.zzY5s(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Shape shape;
        if (imageBytes == null) {
            throw new NullPointerException("imageBytes");
        }
        if (this.zzX2.getCompatibilityOptions().getMswVersion() > 12 || this.zzX2.getCompatibilityOptions().getMswVersion() == 0) {
            shape = new Shape((DocumentBase)this.zzX2, 0);
            zzYLc zzYLc2 = new zzYLc();
            zzYLc2.zzXSC(zzY24.zzYcK("rect"));
            zzYLc2.zzXSC(new zzZKv());
            zzZ0K zzZ0K2 = new zzZ0K();
            zzZ0K2.zzY5s(new zzVXi(this.zzX2.zzuM(), ""));
            zzZ0K2.zzXSC(new zzld());
            zzYLc2.zzXSC(zzZ0K2);
            shape.zzYn4(75);
            shape.zzGr(zzYLc2);
        } else {
            shape = new Shape((DocumentBase)this.zzX2, 75);
        }
        shape.zzXSC(this.zzdb());
        if (shape.getImageData().zzWpA(imageBytes)) {
            imageBytes = shape.getImageData().zzXSC(imageBytes, new zzXfn(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()));
        }
        shape.getImageData().setImageBytes(imageBytes);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        shape.zzGI(width, height);
        return shape;
    }

    private Shape zzZ1N(BufferedImage bufferedImage) throws Exception {
        byte[] byArray;
        zzWi6 zzWi62 = new zzWi6();
        try {
            zzZdc.zzXSC(bufferedImage, zzWi62);
            byArray = zzQ9.zzGr(zzWi62);
        }
        finally {
            zzWi62.close();
        }
        return this.zzYIa(byArray);
    }

    private Shape zzYIa(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzX2, 1);
        shape.zzYn4(75);
        shape.zzXSC(this.zzdb());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzGI(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private Shape zzXSC(zzXD1 zzXD12, String string, boolean bl, BufferedImage bufferedImage) throws Exception {
        zzZgj zzZgj2 = zzZgj.zzYuq(string);
        Shape shape = bufferedImage != null ? this.zzZ1N(bufferedImage) : this.zzYIa(zzYY7.zzXSC(zzZgj2, bl));
        shape.zzYn4(-2);
        shape.getOleFormat().setProgId(zzZgj2.zzYLK);
        shape.getOleFormat().zzY5s(zzYY7.zzXSC(zzXD12, string, bl));
        return shape;
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, BufferedImage presentation) throws Exception {
        return this.zzXSC(zzXD1.zzY5s(stream), progId, asIcon, presentation);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZgj zzZgj2 = zzZgj.zzYKf(zzXpI.zzvj(fileName));
        return this.zzXSC(fileName, isLinked, asIcon, presentation, zzZgj2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, BufferedImage presentation) throws Exception {
        zzZgj zzZgj2 = zzZgj.zzYuq(progId);
        return this.zzXSC(fileName, isLinked, asIcon, presentation, zzZgj2);
    }

    private Shape zzXSC(String string, boolean bl, boolean bl2, BufferedImage bufferedImage, zzZgj zzZgj2) throws Exception {
        Shape shape = bufferedImage != null ? this.zzZ1N(bufferedImage) : this.zzYIa(zzYY7.zzXSC(zzZgj2, bl2));
        shape.zzYn4(-2);
        shape.getOleFormat().setProgId(zzZgj2.zzYLK);
        shape.getOleFormat().zzY5s(zzYY7.zzXSC(string, bl, bl2, zzZgj2));
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    final Shape zzXSC(zzWdp zzWdp2, BufferedImage bufferedImage) throws Exception {
        Shape shape = this.zzZ1N(bufferedImage);
        shape.zzYn4(201);
        shape.getOleFormat().zzY5s(zzWdp2.zzYvq());
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.zzXSC(html, null);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        zz4W zz4W2 = new zz4W();
        zz4W2.zzYvH(useBuilderFormatting);
        zz4W2.zzQo(useBuilderFormatting);
        this.zzXSC(html, zz4W2);
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        return zzXWk.zzXSC(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return zzXWk.zzXSC(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzWf3 zzWf32 = new zzWf3();
        return zzWf32.zzXSC(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzBE(this).zzXSC(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzBE(this).zzXSC(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzX2, 75);
        shape.zzXSC(this.zzdb());
        shape.zzZbM(true);
        shape.getSignatureLine().zzXSC(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzGI(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzZGy(this.zzX2);
        this.insertNode(shape);
        return shape;
    }

    private void zzXSC(String string, zz4W zz4W2) throws Exception {
        if (this.zzWP6()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(string);
            this.write(DocumentBuilder.zzXDZ(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzWB3 zzWB32 = zzXWk.zzXSC(string, zz4W2, this);
        zzWB32.zzX03();
    }

    private boolean zzWP6() {
        boolean bl = false;
        if (this.zzX8R().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzX8R().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzXDZ(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        if (this.zzXGR() == null) {
            this.startTable();
        }
        if (this.zzXGR().zzYjg() == 1) {
            this.zzXGR().zz4Z();
        }
        if (this.zzXGR().zzYjg() == 3) {
            this.zzXGR().zzYoO();
        }
        return this.zzXGR().zzOM();
    }

    public Table startTable() {
        this.zzY3U.push(new zzYI8(this));
        return this.zzXGR().startTable();
    }

    public Table endTable() {
        if (this.zzXGR() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXGR().endTable();
        this.zzY3U.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXGR() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXGR().endRow();
        if (this.zzWpP != null && this.zzWpP.getHidden()) {
            row.zzWeN().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzX2, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzX2, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzX2);
        this.zzW0v = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzW0v == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzX2, this.zzW0v);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzX2, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzQ9.zzY5s((Object)importFormatOptions, "ImportFormatOptions");
        return zzZ0T.zzXSC(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Document getDocument() {
        return this.zzX2;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzX2) {
            return;
        }
        this.zzX2 = value;
        this.zzZMW(null);
        this.zzBk = new zzZfN();
        this.zzZDv = null;
        this.zzWpP = null;
        this.zzY3U = new zzZeg();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzWpP == null) {
            DocumentBuilder documentBuilder = this;
            this.zzWpP = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzWpP;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        return this.getCurrentParagraph().getParagraphFormat();
    }

    public ListFormat getListFormat() {
        return this.getCurrentParagraph().getListFormat();
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzYeL == null) {
            this.zzYeL = new RowFormat(this);
        }
        return this.zzYeL;
    }

    public CellFormat getCellFormat() {
        if (this.zzZNV == null) {
            this.zzZNV = new CellFormat(this);
        }
        return this.zzZNV;
    }

    final void zzZ72(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        this.zzWMh().push(this.zzdb());
    }

    public void popFont() {
        zzZeg<zzZfN> zzZeg2 = this.zzWMh();
        if (zzZeg2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzXSC((zzZfN)documentBuilder.zzWMh().pop(), false);
        }
    }

    private zzYdV zzY5s(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzZOv(88);
        zzDF zzDF2 = new zzDF();
        zzDF2.setTarget(string2);
        zzDF2.setScreenTip(string3);
        if (bl) {
            zzDF2.setSubAddress(string);
        } else {
            zzDF2.setAddress(zzYSb.zzG5(string));
            zzDF2.setSubAddress(zzYSb.zzZNy(string));
        }
        this.zz9A(zzDF2.toString());
        FieldSeparator fieldSeparator = this.zzZxs(88);
        return new zzYdV(fieldStart, fieldSeparator, null);
    }

    final zzYdV zzZyk(String string, String string2, String string3) {
        boolean bl = zzYSb.zzXzw(string);
        String string4 = bl ? zzYSb.zzZNy(string) : string;
        return this.zzY5s(string4, bl, string2, string3);
    }

    final FieldEnd zzZml() {
        return this.zzYGl(88, true);
    }

    final zzZfN zzdb() {
        return (zzZfN)this.zzBk.zzWGw();
    }

    final zzZK zzXAS() {
        return (zzZK)this.getCurrentParagraph().zzXaF().zzWGw();
    }

    final zzZ70 zzYWf() {
        return (zzZ70)this.zzWeN().zzWGw();
    }

    final zzWMi zz3L() {
        return (zzWMi)this.zzWxU().zzWGw();
    }

    public boolean isAtStartOfParagraph() {
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzX8R(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzX8R().getNodeType() == 8;
    }

    private void zzVPc(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("text");
        }
        String string2 = zzZe0.zzYdv(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZK2(string2.substring(n4, n4 + n2));
                }
                switch (this.zzYTi) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzXd(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZK2(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    private Run zzXd(String string) {
        Run run = new Run(this.zzX2, string, this.zzdb());
        this.insertNode(run);
        return run;
    }

    public void insertNode(Node node) {
        if (this.zzXGR() != null && this.zzXGR().zzYjg() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        this.zzX8R().getParentNode().insertBefore(node, this.zzX8R());
    }

    final void zzLJ(int n) {
        this.zzY3x(true);
        this.zzZeD(n);
    }

    private void zzZeD(int n) {
        this.insertParagraph();
        zzZXz zzZXz2 = new zzZXz(this.getDocument());
        try {
            zzac zzac2 = (zzac)this.getCurrentSection().zzZUt().zzWGw();
            Section section = new Section(this.zzX2, zzac2);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzX2));
            this.zzX2.insertAfter(section, this.getCurrentSection());
            section.getBody().zzY5s(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzZXz2.dispose();
        }
    }

    final FieldStart zzZOv(int n) {
        return zzXWk.zzXSC(n, this.zzdb(), this.zzX8R(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final Run zz9A(String string) {
        return zzXWk.zzY5s(string, this.zzdb(), this.zzX8R(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    final FieldEnd zzYGl(int n, boolean bl) {
        return zzXWk.zzY5s(n, bl, this.zzdb(), this.zzX8R(), this.getCurrentParagraph(), null, true);
    }

    final FieldSeparator zzZxs(int n) {
        return zzXWk.zzY5s(n, this.zzdb(), this.zzX8R(), (CompositeNode)this.getCurrentParagraph(), null, true);
    }

    private FormField zzXzR(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzX2, new zzZB0(), this.zzdb());
        CompositeNode compositeNode = node == null ? this.getCurrentParagraph() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzY3x(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentParagraph().getParentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXGR() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYZT(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZK2(String string) {
        if (this.zzZt0(string)) {
            zzyX zzyX2 = new zzyX(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzZ15 zzZ152 : zzyX2.zzX81(this.getParagraphFormat().getBidi())) {
                zzVPc zzVPc2 = zzVPc.zzXEZ(zzZ152.zzXWW());
                zzZfN zzZfN2 = this.zzdb();
                zzZfN2.zzWYd(265, zzVPc2);
                if (zzZ152.zzW9r()) {
                    zzZfN2.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzX2, zzZ152.getText(), zzZfN2);
                this.insertNode(run);
            }
            return;
        }
        this.zzXd(string);
    }

    private boolean zzZt0(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzWjG.zzZaA(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 3 || n == 4;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzXSC(zzZfN zzZfN2, boolean bl) {
        this.zzBk = bl ? (zzZfN)zzZfN2.zzWGw() : zzZfN2;
    }

    final void zzXhZ() {
        this.zzBk.clear();
    }

    final void zzyu() {
        if (this.zzHZ() != null) {
            zzWMi zzWMi2 = this.zzHZ().zzWxU();
            this.zzXP2 = (zzWMi)zzWMi2.zzWGw();
            zzWMi2.zzY5s(this.zzXP2);
        }
    }

    final boolean zzXCj() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final void zzYnI(int n) {
        this.zzYTi = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph()) {
            return null;
        }
        return this.zzX8R();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzX8R();
        }
        return (Paragraph)this.zzX8R().getAncestor(8);
    }

    public Story getCurrentStory() {
        return this.getCurrentParagraph().getParentStory();
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzYI8 zzXGR() {
        zzZeg<zzYI8> zzZeg2 = this.zzY3U;
        if (zzZeg2.size() > 0) {
            return (zzYI8)this.zzY3U.peek();
        }
        return null;
    }

    private Cell zzHZ() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zzYkg();
    }

    private zzZeg<zzZfN> zzWMh() {
        if (this.zzZDv == null) {
            this.zzZDv = new zzZeg();
        }
        return this.zzZDv;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzBk.zzts(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzT1(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzT1(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzBk.zzWYd(fontAttr, value);
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWeQ()) {
            this.getCurrentParagraph().zzVVS().zzWYd(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzBk.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzBk.clear();
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzWeQ()) {
            this.getCurrentParagraph().zzVVS().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzWeN().zzts(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzWeN().zzZya(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzWeN().zzWoc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzWeN().zzWYd(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzWeN().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzWeN().clear();
        zzZ70.zzYlv().zzY5s(this.zzWeN());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzWxU().zzts(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzWxU().zzZya(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzWxU().zzWoc(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzQ9.zzXSC(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzHZ() != null ? this.zzHZ().getCellFormat() : this.getCellFormat();
            border.zzXSC(cellFormat);
        }
        this.zzWxU().zzWYd(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzWxU().clear();
    }

    private Node zzX8R() {
        Node node = this.zzWFt != null && this.zzWFt.getParentNode() == null ? this.zzXdx : this.zzWFt;
        if (node != null && node.zzVTv() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        return node;
    }

    private void zzZMW(Node node) {
        this.zzWFt = node;
        if (this.zzWFt != null) {
            this.zzXdx = this.zzWFt.getParentNode();
        }
    }

    private zzZ70 zzWeN() {
        if (this.zzXGR() != null && this.zzXGR().zzYjg() == 1) {
            return this.zzWDr;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzWeN();
        }
        return this.zzWDr;
    }

    private zzWMi zzWxU() {
        if (this.zzXGR() != null && this.zzXGR().zzYjg() != 3) {
            return this.zzXP2;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zzYkg().zzWxU();
        }
        return this.zzXP2;
    }
}

