/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.internal.zzWAJ;
import com.aspose.words.internal.zzXD1;
import com.aspose.words.internal.zzYfm;
import com.aspose.words.internal.zzZ51;
import com.aspose.words.internal.zzZDw;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzm7;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzI3 = new HashMap();
    private static HashMap<Integer, Integer> zzYkS = new HashMap();
    private static HashMap<Integer, Integer> zzZ7c = new HashMap();
    private static HashMap<Integer, Integer> zzZG3 = new HashMap();
    private static HashMap<Integer, Integer> zzYxx = new HashMap();
    private static HashMap<Integer, Integer> zzZ1z = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzQ9.zzXSC(fileName, "fileName");
        zzZ51 zzZ512 = zzQ9.zzWYd(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzW0X(zzZ512);
            return fileFormatInfo;
        }
        finally {
            ((zzXD1)zzZ512).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzW0X(zzZDw.zzXSC(stream));
    }

    static FileFormatInfo zzW0X(zzXD1 zzXD12) throws Exception {
        if (zzXD12 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzm7 zzm72 = new zzm7();
            zzXD1 zzXD13 = zzXD12;
            zzm7 zzm73 = zzm72;
            return zzm72.zzY5s(zzXD13, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzXSC(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZdU(zzYfm.zzWXQ(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzZ6R(zzYfm.zzWXQ(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzWAJ.zzZtk(string = zzYfm.zzW05(FileFormatUtil.zzXe0(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZdU(FileFormatUtil.zzZvV(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzZ6R(FileFormatUtil.zzXe0(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYfm.zzW05(FileFormatUtil.zzZvV(saveFormat));
        if (zzWAJ.zzZtk(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzZ6R(zzYfm.zzYeO(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYfm.zzW05(FileFormatUtil.zzY6i(imageType));
    }

    static Exception zzXSC(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzIJ(int n) {
        return zzYfm.toString(FileFormatUtil.zzZvV(n));
    }

    static int zzZ6R(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzQ9.zzXSC(zzYxx, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzY81(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzQ9.zzXSC(zzZ1z, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzXv3(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzXe0(int n) {
        return zzQ9.zzXSC(zzI3, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzZvV(int n) {
        return zzQ9.zzXSC(zzYkS, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzY6i(int n) {
        return zzQ9.zzXSC(zzZ7c, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZdU(int n) {
        return zzQ9.zzXSC(zzZG3, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzZuz(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzQ9.zzY5s(zzYxx, Integer.valueOf(n), Integer.valueOf(n2));
            zzQ9.zzY5s(zzYkS, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzZG3.containsKey(n)) {
                zzQ9.zzY5s(zzZG3, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzQ9.zzY5s(zzI3, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzQ9.zzY5s(zzZ1z, Integer.valueOf(n), Integer.valueOf(n4));
            zzQ9.zzY5s(zzZ7c, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzZuz(11, 10, 10, 1);
        FileFormatUtil.zzZuz(11, 0, 0, 1);
        FileFormatUtil.zzZuz(12, 11, 11, 1);
        FileFormatUtil.zzZuz(13, 20, 20, 1);
        FileFormatUtil.zzZuz(13, 0, 254, 1);
        FileFormatUtil.zzZuz(14, 21, 21, 1);
        FileFormatUtil.zzZuz(15, 22, 22, 1);
        FileFormatUtil.zzZuz(16, 23, 23, 1);
        FileFormatUtil.zzZuz(18, 24, 24, 1);
        FileFormatUtil.zzZuz(19, 25, 25, 1);
        FileFormatUtil.zzZuz(20, 26, 26, 1);
        FileFormatUtil.zzZuz(21, 27, 27, 1);
        FileFormatUtil.zzZuz(24, 30, 30, 1);
        FileFormatUtil.zzZuz(17, 31, 31, 1);
        FileFormatUtil.zzZuz(25, 50, 50, 1);
        FileFormatUtil.zzZuz(26, 45, 255, 1);
        FileFormatUtil.zzZuz(27, 51, 51, 1);
        FileFormatUtil.zzZuz(28, 0, 52, 1);
        FileFormatUtil.zzZuz(22, 60, 60, 1);
        FileFormatUtil.zzZuz(23, 61, 61, 1);
        FileFormatUtil.zzZuz(32, 40, 255, 1);
        FileFormatUtil.zzZuz(39, 47, 255, 1);
        FileFormatUtil.zzZuz(40, 48, 255, 1);
        FileFormatUtil.zzZuz(33, 41, 255, 1);
        FileFormatUtil.zzZuz(34, 46, 255, 1);
        FileFormatUtil.zzZuz(36, 42, 255, 1);
        FileFormatUtil.zzZuz(35, 44, 255, 1);
        FileFormatUtil.zzZuz(29, 52, 255, 1);
        FileFormatUtil.zzZuz(30, 70, 62, 1);
        FileFormatUtil.zzZuz(31, 73, 63, 1);
        FileFormatUtil.zzZuz(37, 71, 255, 1);
        FileFormatUtil.zzZuz(8, 100, 255, 1);
        FileFormatUtil.zzZuz(9, 105, 255, 1);
        FileFormatUtil.zzZuz(6, 101, 255, 6);
        FileFormatUtil.zzZuz(7, 102, 255, 7);
        FileFormatUtil.zzZuz(5, 104, 255, 5);
        FileFormatUtil.zzZuz(4, 0, 255, 4);
        FileFormatUtil.zzZuz(3, 0, 255, 3);
        FileFormatUtil.zzZuz(38, 72, 255, 1);
        FileFormatUtil.zzZuz(2, 103, 255, 2);
    }
}

