/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzLJ;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.internal.zzWAJ;
import com.aspose.words.internal.zzX2F;
import com.aspose.words.internal.zzXfq;
import com.aspose.words.internal.zzqk;
import com.aspose.words.zzY2Y;
import com.aspose.words.zzZB0;
import com.aspose.words.zzZe0;
import com.aspose.words.zzZfN;
import com.aspose.words.zzf2;
import com.aspose.words.zzm5;

public class FormField
extends SpecialChar {
    private zzZB0 zzRc;
    private Field zzgk;
    static String zzWKI = zzXfq.zzW3w('\u2002', 5);
    private static final zzX2F zz7q = new zzX2F("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZB0 formFieldPr, zzZfN runPr) {
        super(doc, '\u0001', runPr);
        this.zzRc = formFieldPr;
    }

    @Override
    final Node zzXSC(boolean bl, zzf2 zzf22) {
        FormField formField = (FormField)super.zzXSC(bl, zzf22);
        ((FormField)super.zzXSC(bl, zzf22)).zzRc = (zzZB0)this.zzRc.zzWGw();
        formField.zzgk = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzQ9.zzXSC((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZOc().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n = FormField.zzYZX(this.getTextInputFormat());
                this.setResult(zzWAJ.zzZdT((String)newValue, n));
                return;
            }
            case 1: {
                FieldOptions fieldOptions = this.zzWuN().getFieldOptions();
                this.setResult(zzqk.zzXSC(zzQ9.zzZuz(newValue), this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzZe0.zzXl6((zzLJ)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    private static int zzYZX(String string) {
        string = string.toLowerCase();
        switch (zz7q.zzWbu(string)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private FieldStart zzWTe() {
        int n = 0;
        zzY2Y zzY2Y2 = zzY2Y.zzVTj(this);
        do {
            Node node = zzY2Y2.getNode();
            switch (node.getNodeType()) {
                case 22: {
                    if (n == 0) {
                        return (FieldStart)node;
                    }
                    --n;
                    break;
                }
                case 24: {
                    ++n;
                }
            }
        } while (zzY2Y2.zzXSC(null, false, true, true, false, false));
        return null;
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzRc.getName();
    }

    public void setName(String value) throws Exception {
        zzQ9.zzY5s((Object)value, "value");
        this.zzRc.setName(value);
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(this.zzRc.getName());
        }
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzXRr() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    final Field getField() {
        FieldStart fieldStart;
        if (this.zzgk == null && (fieldStart = this.zzWTe()) != null) {
            this.zzgk = fieldStart.getField();
        }
        return this.zzgk;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().zzXQT(true);
                if (zzXfq.zzZaA(string, zzWKI)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZhM();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzQ9.zzY5s((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzqk.zzXxW(value) != 0);
                return;
            }
            case 83: {
                this.zzYrO(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzRc.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzRc.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzRc.zzYvK();
    }

    public void setOwnStatus(boolean value) {
        this.zzRc.zzZnx(value);
    }

    public String getHelpText() {
        return this.zzRc.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzRc.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzRc.zzZFZ();
    }

    public void setOwnHelp(boolean value) {
        this.zzRc.zzWPm(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzRc.zzZwT();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzRc.zzY0x(value);
    }

    public String getEntryMacro() {
        return this.zzRc.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzRc.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzRc.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzRc.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzRc.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzRc.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzRc.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzRc.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzRc.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzRc.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzRc.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzRc.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzWJO(21);
            zzm5.zzXSC(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzWuN());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzRc.zzXgW();
    }

    public void setMaxLength(int value) {
        this.zzRc.zzYOU(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzRc.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZB0 zzZB02 = this.zzRc;
        if (zzZB02.zzlw(21070)) {
            return this.zzRc.zzY5v();
        }
        return this.zzRc.zzZek();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzRc.zzZG6(value);
    }

    final String zzZhM() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzYrO(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzWAJ.zzYYU(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZB0 zzZB02 = this.zzRc;
        if (zzZB02.zzlw(21010)) {
            return this.zzRc.zzVYW();
        }
        return this.zzRc.zzYK();
    }

    public void setChecked(boolean value) {
        this.zzRc.zzYJD(value);
    }

    public boolean getDefault() {
        return this.zzRc.zzYK();
    }

    public void setDefault(boolean value) {
        this.zzRc.zzXqi(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzRc.zzWLD();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzRc.zzWlg(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzRc.zzZFb();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzRc.zzYZm(zzQ9.zzYnv(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzQ9.zzXSC((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzQ9.zzXSC((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZB0 zzZ59() {
        return this.zzRc;
    }
}

