/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.List;
import com.aspose.words.ListCollection;
import com.aspose.words.ListLevel;
import com.aspose.words.Paragraph;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.zzWWU;
import com.aspose.words.zzXWk;
import com.aspose.words.zzu1;

public class ListFormat {
    private zzWWU zzWHk;
    private zzu1 zzZV0;
    private ListCollection zzYKQ;
    private ListLevel zzYHI;
    private ListLevel zzZSh;

    ListFormat(zzWWU parentParaAttrs, zzu1 parentRunAttrs, ListCollection lists) {
        this.zzWHk = parentParaAttrs;
        this.zzZV0 = parentRunAttrs;
        this.zzYKQ = lists;
    }

    public void applyBulletDefault() {
        if (this.zzYKQ.getCount() > 2046) {
            zzXWk.zzY5s(this.zzYKQ.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzW4y(listFormat.zzYKQ.add(0).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzYHI = null;
    }

    public void applyNumberDefault() {
        if (this.zzYKQ.getCount() > 2046) {
            zzXWk.zzY5s(this.zzYKQ.getDocument().getWarningCallback(), 17, "List count exceed maximum allowed, document can have problem while opened in MS Word.", new Object[0]);
        }
        ListFormat listFormat = this;
        listFormat.zzW4y(listFormat.zzYKQ.add(6).getListId());
        this.setListLevelNumber(0);
        ListFormat listFormat2 = this;
        this.zzYHI = null;
    }

    public void removeNumbers() {
        this.setList(null);
        ListFormat listFormat = this;
        this.zzYHI = null;
    }

    public void listIndent() {
        if (this.getListLevelNumber() < 8) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.getListLevelNumber() + 1);
            ListFormat listFormat2 = this;
            this.zzYHI = null;
        }
    }

    public void listOutdent() {
        if (this.getListLevelNumber() > 0) {
            ListFormat listFormat = this;
            listFormat.setListLevelNumber(listFormat.getListLevelNumber() - 1);
            ListFormat listFormat2 = this;
            this.zzYHI = null;
        }
    }

    public int getListLevelNumber() {
        return (Integer)this.zzWHk.fetchParaAttr(1110);
    }

    public void setListLevelNumber(int value) {
        this.zzWHk.setParaAttr(1110, value);
        ListFormat listFormat = this;
        this.zzYHI = null;
    }

    final int zzYSI() {
        Paragraph paragraph = zzQ9.zzXSC((Object)this.zzWHk, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzWN9(1110, 1);
        }
        return this.getListLevelNumber();
    }

    public boolean isListItem() {
        return this.getListId() != 0;
    }

    public List getList() {
        int n = this.getListId();
        if (n != 0) {
            return this.zzYKQ.zzZB6(n);
        }
        return null;
    }

    public void setList(List value) {
        if (value == null) {
            this.zzW4y(0);
            this.setListLevelNumber(0);
        } else {
            if (value.getDocument() != this.zzYKQ.getDocument()) {
                throw new IllegalArgumentException("The list belongs to a different document.");
            }
            if (value.isListStyleDefinition()) {
                throw new IllegalArgumentException("The list is a definition of a list style.");
            }
            this.zzW4y(value.getListId());
        }
        ListFormat listFormat = this;
        this.zzYHI = null;
    }

    final List zzXCg() {
        int n = this.zzWsA();
        if (n != 0) {
            return this.zzYKQ.zzZB6(n);
        }
        return null;
    }

    public ListLevel getListLevel() {
        try {
            Document document = zzQ9.zzXSC((Object)this.zzYKQ.getDocument(), Document.class);
            if (document != null && document.getRevisionsView() == 1) {
                return this.zzYEY();
            }
            return this.zzYT9();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private ListLevel zzYT9() {
        try {
            if (this.zzYHI == null) {
                List list = this.getList();
                ListLevel listLevel = list != null ? list.zzYpD(this.getListLevelNumber()) : null;
                this.zzYHI = listLevel != null ? new ListLevel(listLevel, this.zzZV0) : null;
            }
            return this.zzYHI;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final ListLevel zzYEY() {
        if (this.zzZSh == null) {
            List list = this.zzXCg();
            ListLevel listLevel = list != null ? list.zzYpD(this.zzYSI()) : null;
            this.zzZSh = listLevel != null ? new ListLevel(listLevel, this.zzZV0) : null;
        }
        return this.zzZSh;
    }

    final int getListId() {
        return (Integer)this.zzWHk.fetchParaAttr(1120);
    }

    private void zzW4y(int n) {
        Object object = this.zzWHk.getDirectParaAttr(1160);
        int n2 = object != null ? (Integer)object : 0;
        int n3 = 0;
        if (n2 != 0 && n != 0 && this.getListLevel() != null && n2 < (n3 = this.getListLevel().zzXaF().zzZlh() + this.getListLevel().zzXaF().zzYDZ())) {
            n3 = 0;
        }
        this.zzWHk.setParaAttr(1120, n);
        ListFormat listFormat = this;
        this.zzYHI = null;
        if (n == 0 || object == null || this.getListLevel() == null) {
            return;
        }
        if (n2 == 0) {
            this.zzWHk.removeParaAttr(1160);
            return;
        }
        int n4 = n2 - n3 + this.getListLevel().zzXaF().zzZlh() + this.getListLevel().zzXaF().zzYDZ();
        this.zzWHk.setParaAttr(1160, n4);
    }

    private int zzWsA() {
        Paragraph paragraph = zzQ9.zzXSC((Object)this.zzWHk, Paragraph.class);
        if (paragraph != null) {
            return (Integer)paragraph.zzWN9(1120, 1);
        }
        return this.getListId();
    }
}

