/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.internal.zzXfq;
import com.aspose.words.internal.zzZeg;
import com.aspose.words.zzXWk;
import com.aspose.words.zzY2Y;
import com.aspose.words.zzYLM;
import com.aspose.words.zzf2;

public abstract class Node
implements Cloneable {
    private Node zzXM9;
    private Node zzW01;
    private Node zzZ5y;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzY5s(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzXM9 == null) {
            return null;
        }
        if (this.zzXM9.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzXM9;
    }

    final CompositeNode zzZOc() {
        if (zzXWk.zzXjC(this.getParentNode())) {
            return this.getParentNode().zzZOc();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzXM9 == null) {
            return null;
        }
        return this.zzXM9.getDocument();
    }

    final Document zzWuN() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzXh6() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzWoM();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzZ5y;
    }

    final Node zzYet() {
        Node node = this;
        while ((node = node.getPreviousSibling()) != null && zzXWk.zzZGy(node)) {
        }
        return node;
    }

    final Node zzYbX() {
        Node node = zzXWk.zzW3w(this.getPreviousSibling(), false);
        if (node == null && zzXWk.zzXjC(this.getParentNode())) {
            node = this.getParentNode().zzYbX();
        }
        return node;
    }

    final Node zzeK() {
        Node node = zzXWk.zzWmO(this.getNextSibling(), false);
        if (node == null && zzXWk.zzXjC(this.getParentNode())) {
            node = this.getParentNode().zzeK();
        }
        return node;
    }

    final CompositeNode zzYbv() {
        Node node = this;
        while ((node = node.zzYbX()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzWHE() {
        Node node = this;
        while ((node = node.zzeK()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzW01;
    }

    final Node zzXAE() {
        Node node = this;
        while ((node = node.getNextSibling()) != null && zzXWk.zzZGy(node)) {
        }
        return node;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzPp() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZin() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYf7() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzXWk.zzXR1(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzWvw() {
        return this.zzW01;
    }

    final void zzXRV(Node node) {
        this.zzW01 = node;
    }

    final Node zzXBh() {
        return this.zzZ5y;
    }

    final void zzZHB(Node node) {
        this.zzZ5y = node;
    }

    final Node zzWu0() {
        Node node = this;
        if (node.zzW01 != null) {
            node = this;
            return node.zzW01;
        }
        return this.getParentNode();
    }

    final int zzVTv() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzXWk.zzYWl(this);
        boolean bl2 = zzXWk.zzuT(this);
        boolean bl3 = zzXWk.zzWM3(this);
        boolean bl4 = zzXWk.zzYax(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzVTv() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 36;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzVTv() != 3 && n2 != 6 && n != 27 && n != 33)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzXSC(isCloneChildren, null);
    }

    Node zzXSC(boolean bl, zzf2 zzf22) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzXM9 != null) {
            node.zzXM9 = this.getDocument().zzX2v();
        }
        node.zzW01 = null;
        node.zzZ5y = null;
        if (zzf22 != null) {
            zzf22.zzVV9(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzZuz(StringBuilder stringBuilder) {
        zzQ9.zzY5s(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZmY(Node node) {
        this.zzXM9 = node != null ? node : this.getDocument().zzX2v();
    }

    final void zzY5s(DocumentBase documentBase) {
        this.zzXM9 = documentBase != null ? documentBase.zzX2v() : null;
    }

    final boolean zzY1z(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWa9() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWJO(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYsQ(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzW2m(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZuX(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzYLM zzYLM2 = zzXWk.zz92(saveFormat);
        return zzYLM2.zzYCH(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzYLM zzYLM2 = zzXWk.zzXSC(saveOptions);
        return zzYLM2.zzYCH(this);
    }

    final Node zzXic(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzXWk.zzXsc(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzY2Y zzSg() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzY2Y.zzE9(node);
        }
        return zzY2Y.zzVTj(this.getParentNode());
    }

    final zzY2Y zzXFG() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzY2Y.zzVTj(node);
        }
        return zzY2Y.zzE9(this.getParentNode());
    }

    final boolean zzWhv(Node node) {
        return Node.zzYtV(this, node);
    }

    final boolean zzXXl() {
        return this.getAncestor(1) == null;
    }

    static Node zzYtA(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZeg<Node> zzZeg2 = Node.zzAz(node);
        zzZeg<Node> zzZeg3 = Node.zzAz(node2);
        return Node.zzXSC(zzZeg2, zzZeg3);
    }

    static boolean zzYtV(Node node, Node node2) {
        zzZeg<Node> zzZeg2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZeg<Node> zzZeg3 = Node.zzAz(node);
        Node node3 = Node.zzXSC(zzZeg3, zzZeg2 = Node.zzAz(node2));
        if (node3 == null) {
            return false;
        }
        zzZeg<Node> zzZeg4 = zzZeg3;
        if (zzZeg4.size() == 0 || (zzZeg4 = zzZeg2).size() == 0) {
            zzZeg4 = zzZeg2;
            boolean bl = zzZeg4.size() > 0;
            return bl;
        }
        Object e = zzZeg3.peek();
        Object e2 = zzZeg2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes()) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZeg<Node> zzAz(Node node) {
        zzZeg<Node> zzZeg2 = new zzZeg<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZeg2.push(node2);
        }
        return zzZeg2;
    }

    private static Node zzXSC(zzZeg<Node> zzZeg2, zzZeg<Node> zzZeg3) {
        Node node = null;
        while (zzZeg2.peek() == zzZeg3.peek()) {
            node = (Node)zzZeg2.pop();
            zzZeg3.pop();
            zzZeg<Node> zzZeg4 = zzZeg2;
            if (zzZeg4.size() != 0 && (zzZeg4 = zzZeg3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    private String zzlH() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzQ9.zzXSC(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzXfq.zzZrg(stringBuilder.toString());
    }

    public String toString() {
        return zzXfq.zzZrg(zzXfq.zzY5s("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzlH()));
    }

    public void dd() {
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

