/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzQ9;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzVOD;
import com.aspose.words.zzW3I;
import com.aspose.words.zzWB4;
import com.aspose.words.zzXt8;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzVOD,
Iterable<T> {
    private CompositeNode zzZcv;
    private DocumentBase zzWrC;
    private boolean zz8I;
    private int zzWU9;
    private int zzWIr;
    private Node zzXZI;
    private int zzPQ;
    private zzXt8 zzXtQ;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, new zzWB4(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzWB4(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzXt8 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("container");
        }
        if (matcher == null) {
            throw new NullPointerException("matcher");
        }
        this.zzZcv = container;
        this.zzWrC = container.getDocument();
        this.zzXtQ = matcher;
        this.zz8I = isDeep;
        this.zzZDG();
    }

    public Node get(int index) {
        try {
            this.zzYw1();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzWIr == index) {
                return this.zzXZI;
            }
            int n = index - this.zzWIr;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzak(nodeCollection.zzXZI, n);
            if (node != null) {
                this.zzWIr = index;
                this.zzXZI = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zz8I) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzZcv.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zz8I) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzZcv.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzX5H();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzW3I(this);
    }

    final <TNode extends Node> zzW3I<TNode> zzXSz() {
        return new zzW3I(this);
    }

    final <TValue extends Node> ArrayList<TValue> zzX5H() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzQ9.zzXSC(arrayList, node);
        }
        return arrayList;
    }

    private Node zzak(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            Ref<Node> ref = new Ref<Node>(node2);
            this.zzXSC(ref, bl);
            node2 = ref.get();
            if (node2 != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Ref<Node> curNode) throws Exception {
        return this.zzXSC(curNode, true);
    }

    private Node zzXSC(Ref<Node> ref, boolean bl) throws Exception {
        Node node;
        ref.get();
        do {
            node = ref.get();
            ref.set(this.zz8I ? this.zzXSC(bl, ref.get()) : (this.zzXtQ.zzhN() ? this.zzXl6(bl, ref.get()) : this.zzY5s(bl, ref.get())));
        } while (ref.get() != null && !this.zzXtQ.zzak(ref.get()));
        return node;
    }

    private Node zzXSC(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzZcv);
        }
        return node.previousPreOrder(this.zzZcv);
    }

    private Node zzY5s(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzZcv) {
                return this.zzZcv.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzZcv) {
            return this.zzZcv.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzXl6(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzZcv ? this.zzZcv.zzWDp() : node.zzeK();
        } else {
            Node node3 = node2 = node == this.zzZcv ? this.zzZcv.zzs2() : node.zzYbX();
        }
        if (node2 == this.zzZcv.getNextSibling() || node2 == this.zzZcv.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYw1() {
        if (this.zzWU9 != this.zzZfD()) {
            this.zzZDG();
        }
    }

    private void zzZDG() {
        this.zzWU9 = this.zzZfD();
        this.zzWIr = -1;
        this.zzXZI = this.zzZcv;
        this.zzPQ = -1;
    }

    private int zzZfD() {
        if (this.zzWrC != null) {
            return this.zzWrC.zzXZR();
        }
        return 0;
    }

    public int getCount() {
        this.zzYw1();
        if (this.zzPQ == -1) {
            this.zzPQ = zzW3I.zzXSC(this);
        }
        return this.zzPQ;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzZcv;
    }
}

