/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzXpI;
import com.aspose.words.internal.zzYfm;
import com.aspose.words.zzK6;

public abstract class SaveOptions {
    private boolean zzQd = false;
    private boolean zzYCn = true;
    private boolean zzXry;
    private String zziE;
    private boolean zzXMW;
    private boolean zzWKx = false;
    private boolean zzVRL = true;
    private int zzWwe = 1;
    private int zzAm = 0;
    private int zzZws = 0;
    private String zzWGz = "";
    private boolean zzZxq = true;
    private boolean zzYzc = true;
    private boolean zzZYZ;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZIu() {
        return false;
    }

    boolean zzZVj() {
        return true;
    }

    final boolean zzXiT() {
        return this.zzYCn;
    }

    public String getTempFolder() {
        return this.zziE;
    }

    public void setTempFolder(String value) {
        this.zziE = value;
    }

    public boolean getPrettyFormat() {
        return this.zzXry;
    }

    public void setPrettyFormat(boolean value) {
        this.zzXry = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzXMW;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzXMW = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWKx;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWKx = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzVRL;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzVRL = value;
    }

    public int getColorMode() {
        return this.zzZws;
    }

    public void setColorMode(int value) {
        this.zzZws = value;
    }

    public int getDmlRenderingMode() {
        return this.zzWwe;
    }

    public void setDmlRenderingMode(int value) {
        this.zzWwe = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzAm;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzAm = value;
    }

    public String getDefaultTemplate() {
        return this.zzWGz;
    }

    public void setDefaultTemplate(String value) {
        this.zzWGz = value;
    }

    public boolean getUpdateFields() {
        return this.zzZxq;
    }

    public void setUpdateFields(boolean value) {
        this.zzZxq = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzZYZ;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzZYZ = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzQd;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzQd = value;
    }

    final boolean zz79() {
        return this.zzYzc;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new zzK6();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzZ6R(zzYfm.zzYeO(zzXpI.zzvj(fileName))));
    }
}

